
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the plot with new trends in Environmental Science
years = np.array([2000, 2005, 2010, 2015, 2020])
region_a = np.array([8.0, 8.2, 8.5, 8.7, 9.0])  + np.random.normal(0, 0.05, 5)  # CO2 emissions in MT
region_b = np.array([6.5, 6.7, 7.0, 7.3, 7.6])  + np.random.normal(0, 0.05, 5)
region_c = np.array([7.0, 7.1, 7.4, 7.5, 7.7])  + np.random.normal(0, 0.05, 5)
region_d = np.array([5.5, 5.6, 6.0, 6.2, 6.5])  + np.random.normal(0, 0.05, 5)
global_avg = np.linspace(7.0, 7.0, len(years))  # Global average line

# Labels and parameters for Environmental Science
fill_label_region_a = "Region A"
fill_label_region_b = "Region B"
fill_label_region_c = "Region C"
fill_label_region_d = "Region D"
plot_label_global_avg = "Global Average"
title_text = "CO2 Emissions Trends Over the Years"
xlabel_text = "Year"
ylabel_text = "CO2 Emissions (MT)"
legend_title = "Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot with a different visualization style
plt.figure(figsize=(10, 6))

xlim_values = (min(years), max(years))
ylim_values = (5.0, 9.5)
xticks_values = years
yticks_values = np.arange(5.0, 9.6, 0.5)
legend_loc = "upper left"
legend_bbox_to_anchor = (0.0, 1.0)
legend_ncol = 1

# Plotting data
plt.fill_between(years, region_a, color="#66c2a5", alpha=0.5, label=fill_label_region_a)
plt.fill_between(years, region_b, color="#fc8d62", alpha=0.5, label=fill_label_region_b)
plt.fill_between(years, region_c, color="#8da0cb", alpha=0.5, label=fill_label_region_c)
plt.fill_between(years, region_d, color="#e78ac3", alpha=0.5, label=fill_label_region_d)
plt.plot(years, global_avg, color="#a6d854", linestyle="--", linewidth=2, label=plot_label_global_avg)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=14, y=1.05)
plt.xlabel(xlabel_text, fontsize=12)
plt.ylabel(ylabel_text, fontsize=12)
plt.xticks(xticks_values)
plt.yticks(yticks_values)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    reverse=False,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_28.pdf", bbox_inches="tight")
