
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
import numpy as np

np.random.seed(0)
years = ["2014", "2015", "2016", "2017", "2018", "2019", "2020", "2021"]
visitors = np.array([2, 2.5, 3, 3.2, 3.8, 4, 2, 3.5])
revenue = np.array([1, 1.5, 2, 2.5, 3, 3.4, 1.8, 2.8])
satisfaction = np.array([3, 3.2, 3.5, 3.7, 4, 4.5, 3.2, 3.8])

# Calculate cumulative values for stacked area chart
cumulative_visitors = visitors
cumulative_revenue = cumulative_visitors + revenue
cumulative_satisfaction = cumulative_revenue + satisfaction

# Positions for the bars on the x-axis
ind = np.arange(len(years))

# Variables for plot configuration
visitors_label = "Visitors (millions)"
revenue_label = "Revenue (billion USD)"
satisfaction_label = "Satisfaction (rating)"
xlabel_text = "Year"
ylabel_text = "Performance Metrics"
title_text = "Tourism Performance Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6))

xlim_values = (0, 7)
ylim_values = (0, 12)

yticks_values = np.arange(0, 13, 1)
legend_location = "upper center"
legend_fontsize = 12
legend_frameon = False
legend_shadow = True
legend_facecolor = "#ffffff"
legend_ncol = 3
legend_bbox_to_anchor = (0.5, 1.2)

ax.fill_between(
    years, 0, cumulative_visitors, label=visitors_label, color="#FF6F61", alpha=0.7
)
ax.fill_between(
    years,
    cumulative_visitors,
    cumulative_revenue,
    label=revenue_label,
    color="#6B5B95",
    alpha=0.7,
)
ax.fill_between(
    years,
    cumulative_revenue,
    cumulative_satisfaction,
    label=satisfaction_label,
    color="#88B04B",
    alpha=0.7,
)

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)

ax.set_yticks(yticks_values)
ax.set_ylim(*ylim_values)
ax.set_xlim(*xlim_values)

ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=16, y=1.2)
ax.tick_params(axis="both", which="both", color="gray")

ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_30.pdf", bbox_inches="tight")
