
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
import numpy as np

np.random.seed(42)
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug"]
physical_activity = np.array([1, 2, 3, 5, 7, 6, 8, 9])
nutrition = np.array([2, 3, 2, 4, 5, 6, 5, 4])
mental_wellbeing = np.array([1, 1, 1, 2, 2, 3, 3, 4])

# Calculate cumulative values for stacked area chart
cumulative_physical_activity = physical_activity
cumulative_nutrition = cumulative_physical_activity + nutrition
cumulative_mental_wellbeing = cumulative_nutrition + mental_wellbeing

# Positions for the bars on the x-axis
ind = np.arange(len(months))

# Variables for plot configuration
physical_activity_label = "Physical Activity"
nutrition_label = "Nutrition"
mental_wellbeing_label = "Mental Well-being"
xlabel_text = "Month"
ylabel_text = "Health Progression (%)"
title_text = "Cumulative Health Progression Over Time"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 5))  # Adjusted for better aspect ratio

xlim_values = (0, 7)
ylim_values = (0, 25)

yticks_values = np.arange(0, 26, 2)
legend_location = "upper left"
legend_fontsize = 12
legend_frameon = False
legend_shadow = False
legend_facecolor = "#ffffff"
legend_ncol = 1
legend_bbox_to_anchor = (0.1, 1.0)

ax.fill_between(
    months, 0, cumulative_physical_activity, label=physical_activity_label, color="#66c2a5", alpha=0.7
)
ax.fill_between(
    months,
    cumulative_physical_activity,
    cumulative_nutrition,
    label=nutrition_label,
    color="#fc8d62",
    alpha=0.7,
)
ax.fill_between(
    months,
    cumulative_nutrition,
    cumulative_mental_wellbeing,
    label=mental_wellbeing_label,
    color="#8da0cb",
    alpha=0.7,
)

# Enhancing the plot with additional visuals
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)
ax.set_yticks(yticks_values)
# Setting the x-axis and y-axis limits dynamically
ax.set_ylim(*ylim_values)  # Ensure all data fits well
ax.set_xlim(*xlim_values)
# Labels, Title and Grid
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=16, y=1.1)
ax.tick_params(axis="both", which="both", color="gray")
# Custom legend
ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_31.pdf", bbox_inches="tight")
