
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Importing numpy
import numpy as np

# Generate health-related data
np.random.seed(42)
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug"]
exercise = np.array([2, 4, 6, 8, 10, 9, 7, 5])
diet = np.array([1, 2, 3, 4, 5, 4, 3, 2])
sleep = np.array([3, 3, 4, 5, 6, 5, 4, 3])

# Calculate cumulative values for stacked area chart
cumulative_exercise = exercise
cumulative_diet = cumulative_exercise + diet
cumulative_sleep = cumulative_diet + sleep

# Positions for the bars on the x-axis
ind = np.arange(len(months))

# Variables for plot configuration
exercise_label = "Exercise"
diet_label = "Diet"
sleep_label = "Sleep"
xlabel_text = "Months"
ylabel_text = "Health Benefit Score"
title_text = "Cumulative Health Benefits Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 5))  # Adjusted for better aspect ratio

xlim_values = (0, 7)
ylim_values = (0, 20)

yticks_values = np.arange(0, 21, 2)
legend_location = "upper center"
legend_fontsize = 12
legend_frameon = False
legend_shadow = True
legend_facecolor = "#ffffff"
legend_ncol = 3
legend_bbox_to_anchor = (0.5, 1.2)

# Colors chosen for health theme
ax.fill_between(
    months, 0, cumulative_exercise, label=exercise_label, color="#66c2a5", alpha=0.7
)
ax.fill_between(
    months,
    cumulative_exercise,
    cumulative_diet,
    label=diet_label,
    color="#fc8d62",
    alpha=0.7,
)
ax.fill_between(
    months,
    cumulative_diet,
    cumulative_sleep,
    label=sleep_label,
    color="#8da0cb",
    alpha=0.7,
)

# Enhancing the plot with additional visuals
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)
ax.set_yticks(yticks_values)
# Setting the x-axis and y-axis limits dynamically
ax.set_ylim(*ylim_values)  # Ensure all data fits well
ax.set_xlim(*xlim_values)
# Labels, Title, and Grid
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=16, y=1.2)
ax.tick_params(axis="both", which="both", color="gray")
# Custom legend
ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_32.pdf", bbox_inches="tight")
