
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# New data for literature domain
year = [1950, 1960, 1970, 1980, 1990, 2000, 2010, 2020]
books_by_genre = {
    "Fiction": [100, 150, 200, 250, 300, 350, 400, 450],
    "Non-Fiction": [80, 90, 100, 120, 140, 160, 180, 200],
    "Science Fiction": [50, 60, 70, 80, 90, 100, 120, 140],
    "Biography": [20, 30, 40, 50, 60, 70, 80, 90],
    "Poetry": [10, 20, 25, 30, 35, 40, 45, 50]
}

# Extracted variables for the new plot
legend_labels = list(books_by_genre.keys())
xlabel_value = "Year"
ylabel_value = "Number of Books Published (thousands)"
title_value = "Books Published by Genre Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7))

xlim_values = (1950, 2020)
ylim_values = (0, 1000)
legend_loc = "upper left"
legend_reverse = False
legend_frameon = True
legend_ncol = 1
legend_bbox_to_anchor = (1, 1)
title_y_position = 1.05
colors = ["#d4a373", "#a98467", "#6f4e37", "#3f301d", "#2f1b0c"]

ax.stackplot(
    year,
    books_by_genre.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_34.pdf", bbox_inches="tight")
