
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Generate new economic data
years = np.arange(2018, 2023)
sales = [80, 85, 88, 90, 95]  # Annual Sales in USD million
cogs = [55, 58, 60, 62, 65]  # Annual Cost of Goods Sold (COGS) in USD million
net_income = [25, 27, 28, 28, 30]  # Annual Net Income in USD million

# Labels for legend
label_sales = "Annual Sales"
label_cogs = "Annual COGS"
label_net_income = "Annual Net Income"

# Title and labels
plot_title = "Economic Performance Over the Years"
xlabel_text = "Years"
ylabel_text = "Million USD"

xlim_values = (2018, 2022)
ylim_values = (0, 100)

# Axis labels
xlabel_values = ["2018", "2019", "2020", "2021", "2022"]
ylabel_values = [0, 20, 40, 60, 80, 100]

# Axis ticks
xticks_values = years
yticks_values = [0, 20, 40, 60, 80, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot limits

# Plotting the data with optimized style
title_fontsize = 16
label_fontsize = 14
title_pad = 20
plt.figure(figsize=(12, 8))  # Adjusting figure size to fit better

# Sales line with markers
plt.plot(
    years,
    sales,
    'o-',
    clip_on=False,
    zorder=10,
    markerfacecolor="#FF5733",
    markeredgecolor="#C70039",
    markersize=10,
    color="#900C3F",
    label=label_sales,
    linewidth=2,
)

# COGS line with markers
plt.plot(
    years,
    cogs,
    's-',
    clip_on=False,
    zorder=10,
    markerfacecolor="#FFC300",
    markeredgecolor="#FF5733",
    markersize=10,
    color="#FF5733",
    label=label_cogs,
    linewidth=2,
)

# Net Income line with markers
plt.plot(
    years,
    net_income,
    'd-',
    clip_on=False,
    zorder=10,
    markerfacecolor="#DAF7A6",
    markeredgecolor="#FFC300",
    markersize=10,
    color="#FFC300",
    label=label_net_income,
    linewidth=2,
)

# Filling the area under the curves
plt.fill_between(years, sales, cogs, color="#FF5733", alpha=0.3)
plt.fill_between(years, cogs, net_income, color="#FFC300", alpha=0.3)
plt.fill_between(years, net_income, 0, color="#DAF7A6", alpha=0.3)

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis and y-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend
plt.legend(loc="upper left", frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Adding title and labels
plt.title(plot_title, fontsize=title_fontsize, pad=title_pad)
plt.xlabel(xlabel_text, fontsize=label_fontsize)
plt.ylabel(ylabel_text, fontsize=label_fontsize)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_36.pdf", bbox_inches="tight")
