
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
years = [2018, 2019, 2020, 2021, 2022]
energy_consumption = [500, 520, 540, 560, 580]  # Annual Energy Consumption in TWh
energy_production = [450, 460, 475, 500, 530]  # Annual Energy Production in TWh
renewable_energy = [150, 180, 210, 250, 290]  # Renewable Energy Production in TWh

# Labels for legend
label_consumption = "Energy Consumption"
label_production = "Energy Production"
label_renewable = "Renewable Energy Production"

# Title and Labels
plot_title = "Energy Overview Over the Years"
xlabel_text = "Years"
ylabel_text = "Energy (TWh)"

xlim_values = (2018, 2022)
ylim_values = (0, 600)

# Axis labels
xlabel_values = ["2018", "2019", "2020", "2021", "2022"]
ylabel_values = [0, 100, 200, 300, 400, 500, 600]

# Axis ticks
xticks_values = years
yticks_values = [0, 100, 200, 300, 400, 500, 600]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot limits

# Plotting the data
title_fontsize = 16
label_fontsize = 14
title_pad = 20
plt.figure(figsize=(12, 8))  # Adjusting figure size to fit better

plt.plot(
    years,
    energy_consumption,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#1f78b4",
    markeredgecolor="#1f78b4",
    markersize=10,
    color="#1f78b4",
    label=label_consumption,
)
plt.plot(
    years,
    energy_production,
    "--",
    clip_on=False,
    zorder=10,
    markerfacecolor="#ff7f0e",
    markeredgecolor="#ff7f0e",
    markersize=10,
    color="#ff7f0e",
    label=label_production,
)
plt.plot(
    years,
    renewable_energy,
    "d-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#2ca02c",
    markeredgecolor="#2ca02c",
    markersize=10,
    color="#2ca02c",
    label=label_renewable,
)

# Filling the area under the curves
plt.fill_between(years, energy_consumption, energy_production, color="#1f78b4", alpha=0.4)
plt.fill_between(years, energy_production, renewable_energy, color="#ff7f0e", alpha=0.4)
plt.fill_between(years, renewable_energy, 0, color="#2ca02c", alpha=0.4)

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis and y-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend
plt.legend(loc="upper left", frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Adding title and labels
plt.title(plot_title, fontsize=title_fontsize, pad=title_pad)
plt.xlabel(xlabel_text, fontsize=label_fontsize)
plt.ylabel(ylabel_text, fontsize=label_fontsize)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_37.pdf", bbox_inches="tight")
