
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting (Types of Legal Cases over Years)
years = [2015, 2016, 2017, 2018, 2019]
civil_cases = [200, 220, 210, 230, 240]
criminal_cases = [150, 160, 170, 180, 190]
corporate_cases = [100, 110, 105, 115, 120]
family_cases = [80, 90, 85, 95, 100]

# Labels for legend
label_civil = "Civil Cases"
label_criminal = "Criminal Cases"
label_corporate = "Corporate Cases"
label_family = "Family Cases"

# Horizontal line value
axhline_value = 180

# Chart text labels
title = "Number of Legal Cases Handled Over the Years"
xlabel = "Year"
ylabel = "Number of Cases"
xlabel_values = ["2015", "2016", "2017", "2018", "2019"]
ylabel_values = range(0, 301, 50)
xticks_values = years
yticks_values = range(0, 301, 50)

# Plot limits
xlim_values = (2015, 2019)
ylim_values = (0, 300)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 6))

plt.plot(
    years,
    civil_cases,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#377eb8",
    markeredgecolor="#345b9e",
    markersize=10,
    color="#345b9e",
    label=label_civil,
)
plt.plot(
    years,
    criminal_cases,
    "s--",
    clip_on=False,
    zorder=10,
    markerfacecolor="#4daf4a",
    markeredgecolor="#3b8b3a",
    markersize=10,
    color="#3b8b3a",
    label=label_criminal,
)
plt.plot(
    years,
    corporate_cases,
    "d-.",
    clip_on=False,
    zorder=10,
    markerfacecolor="#984ea3",
    markeredgecolor="#7a3c7e",
    markersize=10,
    color="#7a3c7e",
    label=label_corporate,
)
plt.plot(
    years,
    family_cases,
    "^:",
    clip_on=False,
    zorder=10,
    markerfacecolor="#e41a1c",
    markeredgecolor="#b01716",
    markersize=10,
    color="#b01716",
    label=label_family,
)

# Filling the area under the curves
plt.fill_between(years, civil_cases, criminal_cases, color="#377eb8", alpha=0.2)
plt.fill_between(years, criminal_cases, corporate_cases, color="#4daf4a", alpha=0.2)
plt.fill_between(years, corporate_cases, family_cases, color="#984ea3", alpha=0.2)
plt.fill_between(years, family_cases, color="#e41a1c", alpha=0.2)

# Adding a horizontal dashed line at y=axhline_value
plt.axhline(axhline_value, color="black", linestyle="dotted")

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend at the bottom
plt.legend(loc="upper left", ncol=1, bbox_to_anchor=(1, 1), frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Adding grid lines for better readability
plt.grid(True, which="both", linestyle="--", linewidth=0.5)

# Adding chart title and axis labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_39.pdf", bbox_inches="tight")
