
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Simulated data for temperature and precipitation over months
months = np.linspace(1, 12, 12)  # 12 months
temperature = np.array([30, 32, 35, 40, 45, 47, 50, 48, 42, 38, 35, 32])  # degrees Celsius
temperature_pred = temperature + np.random.normal(0, 2, len(temperature))
precipitation = np.array([80, 70, 60, 50, 40, 30, 20, 25, 35, 55, 65, 75])  # mm of rain
precipitation_pred = precipitation + np.random.normal(0, 5, len(precipitation))

# Extracted variables
temperature_label = "Actual Temperature"
temperature_pred_label = "Predicted Temperature"
precipitation_label = "Actual Precipitation"
precipitation_pred_label = "Predicted Precipitation"

temperature_ylabel = "Temperature (°C)"
precipitation_xlabel = "Months"
precipitation_ylabel = "Precipitation (mm)"
legend_labels = ["Actual", "Predicted"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
temperature_ylim = [20, 55]
temperature_xlim = [1, 12]
temperature_yticks = np.arange(20, 60, 5)
temperature_xticks = np.arange(1, 13, 1)
precipitation_ylim = [0, 100]
precipitation_xlim = [1, 12]
precipitation_yticks = np.arange(0, 110, 10)
precipitation_xticks = temperature_xticks

legend_loc = "upper right"
legend_bbox_to_anchor = (1, 1.15)
legend_ncol = 2
legend_frameon = False

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(12, 12))

# Plot Temperature
ax1.plot(months, temperature, "o-", color="#FF5733", label=temperature_label)
ax1.fill_between(months, temperature, color="#FFC300", alpha=0.5)
ax1.plot(months, temperature_pred, "s--", color="#C70039", label=temperature_pred_label)
ax1.fill_between(months, temperature_pred, color="#FF5733", alpha=0.3)
ax1.set_ylim(temperature_ylim)
ax1.set_xlim(temperature_xlim)
ax1.set_yticks(temperature_yticks)
ax1.set_xticks(temperature_xticks)
ax1.set_ylabel(temperature_ylabel)
ax1.tick_params(axis="both", which="both", length=0)

# Plot Precipitation
ax2.plot(months, precipitation, "o-", color="#3498DB", label=precipitation_label)
ax2.fill_between(months, precipitation, color="#85C1E9", alpha=0.5)
ax2.plot(months, precipitation_pred, "s--", color="#1F618D", label=precipitation_pred_label)
ax2.fill_between(months, precipitation_pred, color="#3498DB", alpha=0.3)
ax2.set_ylim(precipitation_ylim)
ax2.set_xlim(precipitation_xlim)
ax2.set_yticks(precipitation_yticks)
ax2.set_xticks(precipitation_xticks)
ax2.set_xlabel(precipitation_xlabel)
ax2.set_ylabel(precipitation_ylabel)
ax2.tick_params(axis="both", which="both", length=0)

# Create custom legend
red_line = mlines.Line2D([], [], color="#FF5733", marker="o", markersize=6, label=legend_labels[0])
blue_line = mlines.Line2D([], [], color="#C70039", marker="s", markersize=6, label=legend_labels[1])
plt.legend(handles=[red_line, blue_line], loc=legend_loc, bbox_to_anchor=legend_bbox_to_anchor, ncol=legend_ncol, frameon=legend_frameon)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_43.pdf", bbox_inches="tight")
