
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Simulated data for crop yields (tons) over months
months = np.linspace(1, 12, 12)  # 12 months
crop_yields = np.array([2.5, 3.0, 3.2, 3.5, 4.0, 4.2, 4.5, 4.8, 5.0, 5.2, 5.5, 6.0])
crop_yields_pred = crop_yields + np.random.normal(0, 0.3, len(crop_yields))

# Simulated data for fertilizer usage (kg/ha) over months
fertilizer_usage = np.array([100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 210])
fertilizer_usage_pred = fertilizer_usage + np.random.normal(0, 10, len(fertilizer_usage))

# Extracted variables
crop_yields_label = "Actual Crop Yields"
crop_yields_pred_label = "Predicted Crop Yields"
fertilizer_usage_label = "Actual Fertilizer Usage"
fertilizer_usage_pred_label = "Predicted Fertilizer Usage"

crop_yields_ylabel = "Crop Yields (tons)"
fertilizer_usage_xlabel = "Months"
fertilizer_usage_ylabel = "Fertilizer Usage (kg/ha)"
legend_labels = ["Actual", "Predicted"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
crop_yields_ylim = [0, 7]
crop_yields_xlim = [1, 12]
crop_yields_yticks = [0, 1, 2, 3, 4, 5, 6, 7]
crop_yields_xticks = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
fertilizer_usage_ylim = [80, 220]
fertilizer_usage_xlim = [1, 12]
fertilizer_usage_yticks = [80, 100, 120, 140, 160, 180, 200, 220]
fertilizer_usage_xticks = crop_yields_xticks

legend_loc = "lower center"
legend_bbox_to_anchor = (0.5, -0.2)
legend_ncol = 2
legend_frameon = False

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(12, 12))

# Plot Crop Yields
ax1.plot(months, crop_yields, "o-", color="#2ca02c", label=crop_yields_label)
ax1.fill_between(months, crop_yields, color="#b2df8a", alpha=0.5)
ax1.plot(months, crop_yields_pred, "s-", color="#8c564b", label=crop_yields_pred_label)
ax1.fill_between(months, crop_yields_pred, color="#c49c94", alpha=0.5)
ax1.set_ylim(crop_yields_ylim)
ax1.set_xlim(crop_yields_xlim)
ax1.set_yticks(crop_yields_yticks)
ax1.set_xticks(crop_yields_xticks)
ax1.set_ylabel(crop_yields_ylabel)
ax1.tick_params(axis="both", which="both", length=0)

# Plot Fertilizer Usage
ax2.plot(months, fertilizer_usage, "o-", color="#2ca02c", label=fertilizer_usage_label)
ax2.fill_between(months, fertilizer_usage, color="#b2df8a", alpha=0.5)
ax2.plot(
    months,
    fertilizer_usage_pred,
    "s-",
    color="#8c564b",
    label=fertilizer_usage_pred_label,
)
ax2.fill_between(months, fertilizer_usage_pred, color="#c49c94", alpha=0.5)
ax2.set_ylim(fertilizer_usage_ylim)
ax2.set_xlim(fertilizer_usage_xlim)
ax2.set_yticks(fertilizer_usage_yticks)
ax2.set_xticks(fertilizer_usage_xticks)
ax2.set_xlabel(fertilizer_usage_xlabel)
ax2.set_ylabel(fertilizer_usage_ylabel)
ax2.tick_params(axis="both", which="both", length=0)

# Create custom legend
green_line = mlines.Line2D(
    [], [], color="#2ca02c", marker="o", markersize=6, label=legend_labels[0]
)
brown_line = mlines.Line2D(
    [], [], color="#8c564b", marker="s", markersize=6, label=legend_labels[1]
)
plt.legend(
    handles=[green_line, brown_line],
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
    frameon=legend_frameon,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_44.pdf", bbox_inches="tight")
