
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for 12 months for energy domain
months = np.arange(1, 13)
energy_consumption = np.random.normal(loc=200, scale=30, size=12)
energy_production = 150 + 50 * np.sin(np.pi * months / 6)

# Extracted variables for labels and settings
consumption_label = "Energy Consumption (kWh)"
production_label = "Energy Production (kWh)"

legend_labels = ["Consumption", "Production"]
consumption_ylabel = "Consumption (kWh)"
production_ylabel = "Production (kWh)"
months_xlabel = "Month"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
consumption_ylim = [0, 300]
production_ylim = [0, 300]
months_xticks = np.arange(1, 13, 1)
months_xlim = [1, 12]
yticks = np.arange(0, 301, 50)
legend_loc = "lower center"
legend_bbox_to_anchor = (0.5, -0.15)
legend_ncol = 2
legend_frameon = False

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(12, 18))

# Plot Energy Consumption
ax1.plot(months, energy_consumption, "D--", color="#1f77b4", label=consumption_label)
ax1.set_ylim(consumption_ylim)
ax1.set_xlim(months_xlim)
ax1.set_xticks(months_xticks)
ax1.set_ylabel(consumption_ylabel)
ax1.tick_params(axis="both", which="both", length=0)
ax1.grid(True)

# Plot Energy Production
ax2.plot(months, energy_production, "o-", color="#ff7f0e", label=production_label)
ax2.set_ylim(production_ylim)
ax2.set_xlim(months_xlim)
ax2.set_yticks(yticks)
ax2.set_xticks(months_xticks)
ax2.set_xlabel(months_xlabel)
ax2.set_ylabel(production_ylabel)
ax2.tick_params(axis="both", which="both", length=0)
ax2.grid(True)

# Create custom legend
blue_diamond = mlines.Line2D(
    [],
    [],
    color="#1f77b4",
    marker="D",
    markersize=8,
    label=legend_labels[0],
    linestyle="None",
)
orange_circle = mlines.Line2D(
    [], [], color="#ff7f0e", marker="o", markersize=8, label=legend_labels[1]
)
plt.legend(
    handles=[blue_diamond, orange_circle],
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
    frameon=legend_frameon,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_46.pdf", bbox_inches="tight")

