
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data representing average wheat yield in different regions over years (in tons per hectare)
years = np.array([2000, 2005, 2010, 2015, 2020])

region1_yield = np.array([3.2, 3.5, 3.7, 4.0, 4.3]) + np.random.normal(0, 0.2, 5)
region2_yield = np.array([2.4, 2.6, 2.8, 3.2, 3.5]) + np.random.normal(0, 0.2, 5)
region3_yield = np.array([2.1, 2.4, 2.7, 3.0, 3.3]) + np.random.normal(0, 0.2, 5)
region4_yield = np.array([2.5, 2.6, 2.8, 3.1, 3.5]) + np.random.normal(0, 0.2, 5)

# Extracted variables
fill_label_region1 = "Region 1"
fill_label_region2 = "Region 2"
fill_label_region3 = "Region 3"
fill_label_region4 = "Region 4"
title_text = "Average Wheat Yield Over Years"
xlabel_text = "Year"
ylabel_text = "Yield (tons/ha)"
legend_title = "Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (min(years), max(years))
ylim_values = (1.5, 5.0)
xticks_values = years
yticks_values = np.arange(1.5, 5.1, 0.5)
legend_loc = "upper left"
legend_bbox_to_anchor = (1, 1)
legend_ncol = 1

# Create the plot with a different visualization style
plt.figure(figsize=(10, 7))
plt.fill_between(years, region1_yield, color="#8B4513", alpha=0.6, label=fill_label_region1)
plt.fill_between(years, region2_yield, color="#228B22", alpha=0.6, label=fill_label_region2)
plt.fill_between(years, region3_yield, color="#FFD700", alpha=0.6, label=fill_label_region3)
plt.fill_between(years, region4_yield, color="#1E90FF", alpha=0.6, label=fill_label_region4)

# Add a title and labels
plt.title(title_text, fontsize=16, y=1.05)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_49.pdf", bbox_inches="tight")
