
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data representing annual rainfall in different regions over years (in mm)
years = np.array([2000, 2005, 2010, 2015, 2020])

region1_rainfall = np.array([800, 820, 850, 870, 900]) + np.random.normal(0, 30, 5)
region2_rainfall = np.array([600, 620, 640, 660, 680]) + np.random.normal(0, 25, 5)
region3_rainfall = np.array([400, 420, 430, 450, 470]) + np.random.normal(0, 20, 5)
region4_rainfall = np.array([1000, 1040, 1070, 1100, 1150]) + np.random.normal(0, 35, 5)

# Extracted variables
fill_label_region1 = "Region 1"
fill_label_region2 = "Region 2"
fill_label_region3 = "Region 3"
fill_label_region4 = "Region 4"
title_text = "Annual Rainfall Over Years"
xlabel_text = "Year"
ylabel_text = "Rainfall (mm)"
legend_title = "Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (min(years), max(years))
ylim_values = (350.0, 1200.0)
xticks_values = years
yticks_values = np.arange(350.0, 1250.0, 100.0)
legend_loc = "upper left"
legend_bbox_to_anchor = (1, 1)
legend_ncol = 1

# Create the plot with a different visualization style
plt.figure(figsize=(10, 7))
plt.fill_between(years, region1_rainfall, color="#1f77b4", alpha=0.5, label=fill_label_region1)
plt.fill_between(years, region2_rainfall, color="#ff7f0e", alpha=0.5, label=fill_label_region2)
plt.fill_between(years, region3_rainfall, color="#2ca02c", alpha=0.5, label=fill_label_region3)
plt.fill_between(years, region4_rainfall, color="#d62728", alpha=0.5, label=fill_label_region4)

# Add a title and labels
plt.title(title_text, fontsize=16, y=1.05)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_50.pdf", bbox_inches="tight")
