
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the plot with different educational metrics
months = np.array([1, 2, 3, 4, 5, 6])
average_grades = np.array([75, 78, 80, 82, 85, 87]) + np.random.uniform(-2, 2, 6)
attendance_rate = np.array([90, 92, 89, 91, 94, 93]) + np.random.uniform(-1, 1, 6)
assignments_completed = np.array([4, 5, 5, 6, 6, 7]) + np.random.uniform(-0.5, 0.5, 6)
student_satisfaction = np.array([70, 72, 74, 76, 78, 80]) + np.random.uniform(-2, 2, 6)
benchmark_performance = np.linspace(80, 80, len(months))  # Benchmark line

# Extracted variables for labels
fill_label_grades = "Average Grades"
fill_label_attendance = "Attendance Rate (%)"
fill_label_assignments = "Assignments Completed"
fill_label_satisfaction = "Student Satisfaction (%)"
plot_label_benchmark = "Benchmark Performance"
title_text = "Educational Metrics Over 6 Months"
xlabel_text = "Months"
ylabel_text = "Metrics and Rates"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1, 6)
ylim_values = (60, 100)
xticks_values = months
yticks_values = [60, 70, 80, 90, 100]
legend_loc = "upper left"
legend_bbox_to_anchor = (1.05, 1)
legend_ncol = 1

# Create the plot with an educational style
plt.figure(figsize=(12, 7))
plt.fill_between(
    months, average_grades, color="#4c72b0", alpha=0.3, label=fill_label_grades
)
plt.fill_between(
    months, attendance_rate, color="#dd8452", alpha=0.3, label=fill_label_attendance
)
plt.fill_between(
    months, assignments_completed, color="#55a868", alpha=0.3, label=fill_label_assignments
)
plt.fill_between(
    months, student_satisfaction, color="#c44e52", alpha=0.3, label=fill_label_satisfaction
)
plt.plot(
    months,
    benchmark_performance,
    color="#8172b2",
    linestyle="--",
    linewidth=2,
    label=plot_label_benchmark,
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=18, y=1.02)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)
plt.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.7)

# Adding a legend with a title
plt.legend(
    frameon=False,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_51.pdf", bbox_inches="tight")
