
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the plot with different communication metrics
months = np.array([1, 2, 3, 4, 5, 6])
message_volume = np.array([120, 150, 110, 170, 130, 160]) + np.random.uniform(-10, 10, 6)
response_time = np.array([30, 25, 28, 22, 20, 18]) + np.random.uniform(-2, 2, 6)
engagement_rate = np.array([55, 60, 53, 65, 58, 62]) + np.random.uniform(-5, 5, 6)
sentiment_score = np.array([70, 75, 80, 85, 90, 95]) + np.random.uniform(-3, 3, 6)
benchmark_communication = np.linspace(50, 50, len(months))  # Benchmark line

# Extracted variables for labels
fill_label_message_volume = "Message Volume"
fill_label_response_time = "Response Time"
fill_label_engagement_rate = "Engagement Rate"
fill_label_sentiment_score = "Sentiment Score"
plot_label_benchmark = "Benchmark"
title_text = "Communication Metrics Over 6 Months"
xlabel_text = "Months"
ylabel_text = "Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1, 6)
ylim_values = (10, 180)
xticks_values = months
yticks_values = [20, 40, 60, 80, 100, 120, 140, 160, 180]
legend_loc = "upper center"
legend_bbox_to_anchor = (0.5, 1.08)
legend_ncol = 5

# Create the plot with an optimized style
plt.figure(figsize=(10, 6))
plt.fill_between(
    months, message_volume, color="skyblue", alpha=0.3, label=fill_label_message_volume
)
plt.fill_between(
    months, response_time, color="lightgreen", alpha=0.3, label=fill_label_response_time
)
plt.fill_between(
    months, engagement_rate, color="coral", alpha=0.3, label=fill_label_engagement_rate
)
plt.fill_between(
    months, sentiment_score, color="orchid", alpha=0.3, label=fill_label_sentiment_score
)
plt.plot(
    months,
    benchmark_communication,
    color="black",
    linestyle="--",
    linewidth=2,
    label=plot_label_benchmark,
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=16, y=1.05)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)
plt.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.7)

# Adding a legend with a title
plt.legend(
    frameon=False,
    reverse=True,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_52.pdf", bbox_inches="tight")

