
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the plot representing philosophy movements over centuries
centuries = np.array([5, 10, 15, 20, 25, 30])  # 5th-30th century
ancient = np.array([80, 60, 40, 20, 0, 0]) + np.random.normal(0, 5, 6)
medieval = np.array([0, 20, 60, 50, 30, 0]) + np.random.normal(0, 5, 6)
modern = np.array([0, 0, 20, 60, 80, 70]) + np.random.normal(0, 5, 6)
contemporary = np.array([0, 0, 0, 10, 50, 100]) + np.random.normal(0, 5, 6)
benchmark = np.linspace(50, 50, len(centuries))  # Benchmark line

# Extracted variables
fill_label_ancient = "Ancient Philosophy"
fill_label_medieval = "Medieval Philosophy"
fill_label_modern = "Modern Philosophy"
fill_label_contemporary = "Contemporary Philosophy"
plot_label_benchmark = "Benchmark"
title_text = "Philosophical Movements Over Time"
xlabel_text = "Century (AD)"
ylabel_text = "Prevalence (%)"
legend_title = "Philosophy Movements"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (min(centuries), max(centuries))
ylim_values = (0, 110)
xticks_values = centuries
yticks_values = np.arange(0, 111, 10)
legend_loc = "upper left"
legend_bbox_to_anchor = (1.05, 1)
legend_ncol = 1

# Create the plot with a business-appropriate color scheme
plt.figure(figsize=(10, 6))
plt.fill_between(centuries, ancient, color="#8c564b", alpha=0.6, label=fill_label_ancient)  # Earth brown
plt.fill_between(centuries, medieval, color="#2ca02c", alpha=0.6, label=fill_label_medieval)  # Calming green
plt.fill_between(centuries, modern, color="#1f77b4", alpha=0.6, label=fill_label_modern)  # Soft blue
plt.fill_between(centuries, contemporary, color="#d62728", alpha=0.6, label=fill_label_contemporary)  # Calm red
plt.plot(
    centuries,
    benchmark,
    color="gray",
    linestyle="--",
    linewidth=2,
    label=plot_label_benchmark,
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=14, y=1.1)
plt.xlabel(xlabel_text, fontsize=12)
plt.ylabel(ylabel_text, fontsize=12)
plt.xticks(xticks_values)
plt.yticks(yticks_values)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_55.pdf", bbox_inches="tight")
