
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
months = np.arange(1, 13)
court_cases_data = {
    "Civil Cases": np.random.uniform(100, 300, size=12),
    "Criminal Cases": np.random.uniform(80, 220, size=12),
    "Family Cases": np.random.uniform(50, 150, size=12),
    "Traffic Violations": np.random.uniform(40, 120, size=12),
    "Property Disputes": np.random.uniform(30, 100, size=12),
}

# Extracted variables
legend_labels = list(court_cases_data.keys())
xlabel_value = "Month"
ylabel_value = "Number of Cases"
title_value = "Monthly Distribution of Court Cases in 2023"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1, 12)
ylim_values = (0, 1000)
legend_loc = "upper left"
legend_reverse = False
legend_frameon = True
legend_ncol = 1
legend_bbox_to_anchor = (1, 1)
title_y_position = 1.05
colors = ["#FFD700", "#FF6347", "#8A2BE2", "#3CB371", "#1E90FF"]
fig, ax = plt.subplots(figsize=(12, 8))
ax.stackplot(
    months,
    court_cases_data.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)
ax.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_69.pdf", bbox_inches="tight")
