
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
months = np.arange(1, 13)
revenue_data = {
    "Technology": np.random.uniform(100, 500, size=12),
    "Healthcare": np.random.uniform(80, 400, size=12),
    "Finance": np.random.uniform(50, 350, size=12),
    "Consumer Goods": np.random.uniform(30, 200, size=12),
    "Utilities": np.random.uniform(20, 150, size=12),
}

# Extracted variables
legend_labels = list(revenue_data.keys())
xlabel_value = "Month"
ylabel_value = "Revenue ($M)"
title_value = "Monthly Revenue by Sector"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1, 12)
ylim_values = (0, 1500)
legend_loc = "upper left"
legend_reverse = True
legend_frameon = True
legend_ncol = 1
legend_bbox_to_anchor = (1, 1)
title_y_position = 1.05
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]
fig, ax = plt.subplots(figsize=(12, 8))
ax.stackplot(
    months,
    revenue_data.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.grid(True, linestyle='--', linewidth=0.5, alpha=0.7)
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_70.pdf", bbox_inches="tight")
