
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
months = np.arange(1, 13)
tourist_data = {
    "City A": np.random.uniform(1000, 5000, size=12),
    "City B": np.random.uniform(800, 4000, size=12),
    "City C": np.random.uniform(600, 3500, size=12),
    "City D": np.random.uniform(500, 3000, size=12),
    "City E": np.random.uniform(300, 2500, size=12),
}

# Extracted variables
legend_labels = list(tourist_data.keys())
xlabel_value = "Month"
ylabel_value = "Number of Tourist Visits"
title_value = "Monthly Tourist Visits in Different Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1, 12)
ylim_values = (0, 20000)
legend_loc = "upper left"
legend_reverse = True
legend_frameon = True
legend_ncol = 1
legend_bbox_to_anchor = (1, 1)
title_y_position = 1.05
colors = ["#ff6666", "#ffcc66", "#66ff66", "#66ccff", "#cc99ff"]
fig, ax = plt.subplots(figsize=(12, 8))
ax.stackplot(
    months,
    tourist_data.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_71.pdf", bbox_inches="tight")
