
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for 12 months
time_step = np.linspace(1, 12, 12)
approval_rating = 50 + 10 * np.sin(np.pi * time_step / 6) + np.random.normal(0, 2, 12)
policy_support = 30 + 5 * time_step + np.random.normal(0, 2, 12)

# Extracted variables for labels and settings
approval_label = "Public Approval Rating (%)"
policy_support_label = "Policy Support Percent (%)"
approval_ylabel = "Approval Rating (%)"
policy_support_xlabel = "Months"
policy_support_ylabel = "Policy Support (%)"
chart_title = "Political Data Analysis Over 12 Months"
legend_labels = ["Approval Rating", "Policy Support"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
approval_ylim = [30, 70]
approval_xlim = [1, 12]
policy_support_ylim = [30, 90]
policy_support_xlim = [1, 12]
approval_yticks = np.arange(30, 75, 10)
approval_xticks = np.arange(1, 13, 1)
policy_support_yticks = np.arange(30, 95, 10)
policy_support_xticks = np.arange(1, 13, 1)

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 10))

# Plot Approval Rating
ax1.plot(time_step, approval_rating, "o-", color="#1f77b4", label=approval_label)
ax1.fill_between(time_step, approval_rating, color="#aec7e8", alpha=0.3)
ax1.set_ylim(approval_ylim)
ax1.set_xlim(approval_xlim)
ax1.set_yticks(approval_yticks)
ax1.set_xticks(approval_xticks)
ax1.set_ylabel(approval_ylabel)
ax1.tick_params(axis="both", which="both", length=0)
ax1.grid(True)

# Plot Policy Support Percent
ax2.plot(time_step, policy_support, "s--", color="#ff7f0e", label=policy_support_label)
ax2.fill_between(time_step, policy_support, color="#ffbb78", alpha=0.3)
ax2.set_ylim(policy_support_ylim)
ax2.set_xlim(policy_support_xlim)
ax2.set_yticks(policy_support_yticks)
ax2.set_xticks(policy_support_xticks)
ax2.set_xlabel(policy_support_xlabel)
ax2.set_ylabel(policy_support_ylabel)
ax2.tick_params(axis="both", which="both", length=0)
ax2.grid(True)

# Create custom legend
blue_line = mlines.Line2D(
    [], [], color="#1f77b4", marker="o", markersize=6, label=legend_labels[0]
)
orange_line = mlines.Line2D(
    [], [], color="#ff7f0e", marker="s", markersize=6, label=legend_labels[1]
)
plt.legend(
    handles=[blue_line, orange_line],
    loc="lower center",
    bbox_to_anchor=(0.5, -0.2),
    ncol=2,
    frameon=False,
)

# Add title to the plot
plt.suptitle(chart_title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("area_78.pdf", bbox_inches="tight")
