
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
time_step = np.linspace(0, 24, 48)
battery_charge = 100 - (np.arange(48) * 2 + np.random.normal(0, 1.5, 48))
cpu_usage = 5 + 10 * np.abs(np.sin(np.pi * time_step / 12)) + np.random.normal(0, 2, 48)

# Extracted variables for labels and settings
battery_charge_label = "Battery Charge (%)"
cpu_usage_label = "CPU Usage (%)"
battery_charge_ylabel = "Battery Charge (%)"
cpu_usage_xlabel = "Time (hours)"
cpu_usage_ylabel = "CPU Usage (%)"
legend_labels = ["Battery Charge", "CPU Usage"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
cpu_usage_ylim = [0, 20]
cpu_usage_xlim = [0, 24]
battery_charge_ylim = [0, 100]
battery_charge_xlim = [0, 24]
battery_charge_yticks = np.arange(0, 101, 20)
battery_charge_xticks = np.arange(0, 25, 4)
cpu_usage_yticks = np.arange(0, 21, 4)
cpu_usage_xticks = np.arange(0, 25, 4)

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 10))

# Plot Battery Charge
ax1.plot(time_step, battery_charge, "d-", color="#1f77b4", label=battery_charge_label)
ax1.fill_between(time_step, battery_charge, color="#aec7e8", alpha=0.3)
ax1.set_ylim(battery_charge_ylim)
ax1.set_xlim(battery_charge_xlim)
ax1.set_yticks(battery_charge_yticks)
ax1.set_xticks(battery_charge_xticks)
ax1.set_ylabel(battery_charge_ylabel)
ax1.tick_params(axis="both", which="both", length=0)
ax1.grid(True, linestyle='--', alpha=0.7)

# Plot CPU Usage
ax2.plot(time_step, cpu_usage, "p--", color="#ff7f0e", label=cpu_usage_label)
ax2.fill_between(time_step, cpu_usage, color="#ffbb78", alpha=0.3)
ax2.set_ylim(cpu_usage_ylim)
ax2.set_xlim(cpu_usage_xlim)
ax2.set_yticks(cpu_usage_yticks)
ax2.set_xticks(cpu_usage_xticks)
ax2.set_xlabel(cpu_usage_xlabel)
ax2.set_ylabel(cpu_usage_ylabel)
ax2.tick_params(axis="both", which="both", length=0)
ax2.grid(True, linestyle='--', alpha=0.7)

# Create custom legend
blue_line = mlines.Line2D(
    [], [], color="#1f77b4", marker="d", markersize=6, label=legend_labels[0]
)
orange_line = mlines.Line2D(
    [], [], color="#ff7f0e", marker="p", markersize=6, label=legend_labels[1]
)
plt.legend(
    handles=[blue_line, orange_line],
    loc="lower center",
    bbox_to_anchor=(0.5, -0.2),
    ncol=2,
    frameon=False,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_79.pdf", bbox_inches="tight")

