
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for USA
usa_categories = ["Type", "Span", "T&S", "Spurious", "Total"]
usa_manual_mapping = [55, 20, 40, 10, 50]
usa_llm_revision = [60, 30, 45, 15, 55]
usa_llm_revision_wcot = [70, 40, 50, 20, 65]
usa_verifner = [80, 50, 55, 25, 75]

# Data for Canada
canada_categories = ["Type", "Span", "T&S", "Spurious", "Total"]
canada_manual_mapping = [50, 25, 35, 15, 45]
canada_llm_revision = [55, 35, 40, 20, 50]
canada_llm_revision_wcot = [65, 45, 50, 25, 60]
canada_verifner = [75, 55, 60, 30, 70]

labels = ["Manual Mapping", "LLM-revision", "LLM-revision w/CoT", "VerifNER"]
title = "Error Correction Rate (%) for Different Geographic Regions"
title1 = "USA"
title2 = "Canada"

# Axis and Legend Labels
xlabel = "Error Types"
ylabel = "Error Correction Rate (%)"
legend_location = "upper right"

ylim1 = [0, 90]
yticks1 = np.arange(0, 91, 15)
ylim2 = [0, 90]
yticks2 = np.arange(0, 91, 15)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Set up the figure and axes
fig, axs = plt.subplots(2, 1, figsize=(10, 8))  # Width, Height in inches

# Colors
colors = ["#49759c", "#7da6a6", "#dea06e", "#948b57"]
x = np.arange(len(usa_categories))
width = 0.18  # Adjust this value to change the width of the bars
spacing = 0.2  # Adjust this value to change the spacing between the bars

# Plot for USA
axs[0].bar(
    x - spacing * 1.5,
    usa_manual_mapping,
    width,
    label=labels[0],
    color=colors[0],
)
axs[0].bar(x - spacing / 2, usa_llm_revision, width, label=labels[1], color=colors[1])
axs[0].bar(
    x + spacing / 2,
    usa_llm_revision_wcot,
    width,
    label=labels[2],
    color=colors[2],
)
axs[0].bar(x + spacing * 1.5, usa_verifner, width, label=labels[3], color=colors[3])
axs[0].set_title(title1, fontsize=14)
axs[0].set_xticks(x)
axs[0].set_xticklabels(usa_categories, fontsize=12)
axs[0].set_ylim(ylim1)
axs[0].set_yticks(yticks1)
axs[0].legend(loc=legend_location, ncol=2, fontsize=10)

# Plot for Canada
x = np.arange(len(canada_categories))
axs[1].bar(x - spacing * 1.5, canada_manual_mapping, width, color=colors[0])
axs[1].bar(x - spacing / 2, canada_llm_revision, width, color=colors[1])
axs[1].bar(x + spacing / 2, canada_llm_revision_wcot, width, color=colors[2])
axs[1].bar(x + spacing * 1.5, canada_verifner, width, color=colors[3])
axs[1].set_title(title2, fontsize=14)
axs[1].set_xticks(x)
axs[1].set_xticklabels(canada_categories, fontsize=12)
axs[1].set_ylim(ylim2)
axs[1].set_yticks(yticks2)

# Add a common y-axis label and a super title
fig.text(
    0.0001,
    0.5,
    ylabel,
    va="center",
    rotation="vertical",
    fontsize=12,
)
fig.suptitle(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_106.pdf", bbox_inches="tight")
