
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
labels = ["Method A", "Method B", "Method C", "Method D", "Method E", "Method F"]
anxiety_reduction = [0.55, 0.68, 0.62, 0.75, 0.60, 0.70]
mood_improvement = [0.75, 0.80, 0.78, 0.83, 0.82, 0.85]
stress_reduction = [0.70, 0.72, 0.75, 0.78, 0.77, 0.76]

x = np.arange(len(labels))  # the label locations
width = 0.25  # the width of the bars

# Variables for plot configuration
ylabel = "Improvement Score"
xlabel_anxiety = "Anxiety Reduction Methods"
xlabel_stress = "Stress Reduction Methods"

legend_label_anxiety = "Anxiety Reduction"
legend_label_mood = "Mood Improvement"
legend_label_stress = "Stress Reduction"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = x
xticklabels = labels
ylim_ax1 = (0.50, 0.80)
ylim_ax2 = (0.65, 0.90)
yticks_ax1 = [0.50, 0.60, 0.70, 0.80]
yticks_ax2 = [0.65, 0.70, 0.75, 0.80, 0.85, 0.90]

# Setting up the figure and axes for a 2 x 1 layout
fig, (ax1, ax2) = plt.subplots(
    2, 1, figsize=(7, 5), gridspec_kw={"height_ratios": [1, 1], "hspace": 0.3}
)

# Upper plot
rects1 = ax1.bar(
    x - width - 0.04,
    anxiety_reduction,
    width,
    label=legend_label_anxiety,
    color="#a3c1da",
    edgecolor="black",
)
rects2 = ax1.bar(
    x, mood_improvement, width, label=legend_label_mood, color="#b6d7a8", edgecolor="black"
)
rects3 = ax1.bar(
    x + width + 0.04,
    stress_reduction,
    width,
    label=legend_label_stress,
    color="#d9b3ff",
    edgecolor="black",
)

# Lower plot
rects4 = ax2.bar(
    x - width - 0.04, anxiety_reduction, width, color="#a3c1da", edgecolor="black"
)
rects5 = ax2.bar(x, mood_improvement, width, color="#b6d7a8", edgecolor="black")
rects6 = ax2.bar(
    x + width + 0.04, stress_reduction, width, color="#d9b3ff", edgecolor="black"
)

# Add some text for labels, title and custom x-axis tick labels, etc.
ax1.set_ylabel(ylabel)
ax2.set_ylabel(ylabel)
ax1.set_xlabel(xlabel_anxiety)
ax2.set_xlabel(xlabel_stress)
ax1.set_xticks(xticks)
ax1.set_xticklabels(xticklabels)
ax2.set_xticks(xticks)
ax2.set_xticklabels(xticklabels)
ax1.legend(loc="upper center", bbox_to_anchor=(0.5, 1.25), ncol=3, frameon=False)

# Set y-axis limit to match the reference picture
ax1.set_ylim(ylim_ax1)
ax2.set_ylim(ylim_ax2)
ax1.tick_params(axis="x", which="both", length=0)
ax2.tick_params(axis="x", which="both", length=0)
ax1.set_yticks(yticks_ax1)
ax2.set_yticks(yticks_ax2)

# Set grid color and style
ax1.grid(axis="y", color="gray", linestyle="--", linewidth=0.5)
ax2.grid(axis="y", color="gray", linestyle="--", linewidth=0.5)
ax1.tick_params(axis="y", which="major", color="gray")
ax2.tick_params(axis="y", which="major", color="gray")
ax1.set_axisbelow(True)
ax2.set_axisbelow(True)

# Remove top and right borders
ax1.spines["top"].set_visible(False)
ax1.spines["right"].set_visible(False)
ax1.spines["bottom"].set_visible(False)
ax1.spines["left"].set_color("gray")
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)
ax2.spines["bottom"].set_visible(False)
ax2.spines["left"].set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_120.pdf", bbox_inches="tight")
