
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Sample data for Art and Design domain
artists = ["Artist A", "Artist B", "Artist C", "Artist D", "Artist E", "Artist F"]
artworks = {
    "Artist A": [12, 25, 10, 18, 15],
    "Artist B": [10, 17, 22, 19, 12],
    "Artist C": [14, 18, 11, 20, 17],
    "Artist D": [11, 14, 19, 23, 13],
    "Artist E": [14, 18, 21, 12, 15],
    "Artist F": [20, 15, 20, 11, 14],
}

# Variables for plot configuration
title = "Artworks Created by Artists in Different Categories"
xlabel = "Artists"
ylabel = "Number of Artworks"
legend_title = "Categories"
legend_labels = ["Abstract", "Landscape", "Portrait", "Still Life", "Sculpture"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each category
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9", "#92A8D1"]

ylim = (0, 80)
yticks = np.arange(0, 81, 10)

legend_loc = "upper left"
legend_bbox_to_anchor = (1.05, 1.0)
legend_reverse = True

# Plotting the stacked bar chart
fig, ax = plt.subplots(figsize=(10, 6))

for i, artist in enumerate(artists):
    bottom = 0
    for j, count in enumerate(artworks[artist]):
        ax.bar(artist, count, bottom=bottom, color=colors[j])
        bottom += count

# Adding title and labels
ax.set_title(title, fontsize=16, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_ylim(ylim)
ax.set_yticks(yticks)
ax.tick_params(axis="x", which="both", length=0)
ax.tick_params(axis="y", which="both", length=5)

# Adding legend
ax.legend(
    legend_labels,
    title=legend_title,
    frameon=False,
    bbox_to_anchor=legend_bbox_to_anchor,
    loc=legend_loc,
    reverse=legend_reverse,
)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_123.pdf", bbox_inches="tight")
