
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data: Number of different types of vehicles at different checkpoints over a week
checkpoints = ["A1", "B2", "C3", "D4", "E5", "F6"]
vehicle_counts = {
    "A1": [50, 30, 30, 25, 15],
    "B2": [60, 20, 40, 20, 10],
    "C3": [55, 35, 15, 15, 30],
    "D4": [45, 25, 30, 20, 30],
    "E5": [50, 30, 20, 20, 30],
    "F6": [45, 40, 25, 15, 25],
}

# Variables for plot configuration
title = "Vehicle Type Distribution Across Checkpoints"
xlabel = "Checkpoints"
ylabel = "Number of Vehicles"

legend_title = "Vehicle Types"
legend_labels = ["Cars", "Buses", "Trucks", "Motorcycles", "Bicycles"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each vehicle type
colors = ["#2a9d8f", "#264653", "#e76f51", "#f4a261", "#e9c46a"]

ylim = (0, 150)
yticks = [0, 50, 100, 150]

legend_loc = "upper left"
legend_bbox_to_anchor = (1.05, 1.0)
legend_reverse = True

# Plotting the stacked bar chart
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusting figure size

for i, checkpoint in enumerate(checkpoints):
    bottom = 0
    for j, count in enumerate(vehicle_counts[checkpoint]):
        ax.bar(checkpoint, count, bottom=bottom, color=colors[j])
        bottom += count

# Adding title and labels
ax.set_title(title, fontsize=14)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_ylim(ylim)
ax.set_yticks(yticks)
ax.tick_params(axis="both", which="both", length=0)

# Adding legend
ax.legend(
    legend_labels,
    title=legend_title,
    frameon=False,
    bbox_to_anchor=legend_bbox_to_anchor,
    loc=legend_loc,
    reverse=legend_reverse,
)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_124.pdf", bbox_inches="tight")
