
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Sample data for philosophers and themes
philosophers = ["Aristotle", "Plato", "Kant", "Nietzsche", "Socrates", "Descartes"]
scores = {
    "Aristotle": [8, 9, 9, 6, 8],
    "Plato": [6, 10, 8, 7, 9],
    "Kant": [7, 8, 9, 6, 10],
    "Nietzsche": [9, 7, 8, 8, 8],
    "Socrates": [10, 6, 8, 9, 7],
    "Descartes": [7, 8, 8, 8, 9],
}

# Variables for plot configuration
title = "Evaluating Philosophers on Various Themes"
xlabel = "Philosophers"
ylabel = "Scores"
legend_title = "Themes"
legend_labels = ["Ethics", "Metaphysics", "Epistemology", "Logic", "Aesthetics"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each theme
colors = ["#3b6fa1", "#70a1d7", "#80c7e8", "#a1d6e2", "#dee7ec"]

ylim = (0, 40)
yticks = [0, 5, 10, 15, 20, 25, 30, 35, 40]

legend_loc = "upper left"
legend_bbox_to_anchor = (1.05, 1.1)
legend_reverse = False

# Plotting the stacked bar chart
fig, ax = plt.subplots(
    figsize=(10, 6)
)  # Adjusting figure size to accommodate detailed data and aesthetics

for i, philosopher in enumerate(philosophers):
    bottom = 0
    for j, score in enumerate(scores[philosopher]):
        ax.bar(philosopher, score, bottom=bottom, color=colors[j], alpha=0.8)
        bottom += score

# Adding title and labels
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_ylim(ylim)
ax.set_yticks(yticks)
ax.tick_params(axis="both", which="both", length=0)

# Adding legend
ax.legend(
    legend_labels,
    title=legend_title,
    frameon=False,
    bbox_to_anchor=legend_bbox_to_anchor,
    loc=legend_loc,
    reverse=legend_reverse,
)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_125.pdf", bbox_inches="tight")
