
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the plots
roles = ["voters", "candidates", "parties"]
counts_election_2021 = np.array([[250, 150, 600], [350, 250, 400], [200, 350, 450]])
counts_election_2022 = np.array([[300, 200, 500], [350, 300, 350], [220, 380, 400]])

# Variables for plot configuration
xlabel_value = "Count"
ylabel_value = "Roles"
title_election_2021 = "Election 2021"
title_election_2022 = "Election 2022"
legend_labels = ["Local", "Regional", "National"]
fig_title = "Political Participation Over Two Elections"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for the bars
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]
width = 0.3
xlim_value = (0, 1200)
xticks_value = [0, 200, 400, 600, 800, 1000, 1200]
yticks_value = roles
fontsize_title = 16

# Create subplots with shared x-axis
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 7), sharex=True)

# Function to plot stacked bars
def plot_stacked_bars(ax, counts, roles, colors):
    bottom = np.zeros(len(roles))
    for i in range(counts.shape[1]):
        ax.barh(
            roles, counts[:, i], height=width, zorder=5, left=bottom, color=colors[i]
        )
        bottom += counts[:, i]

# Plot for Election 2021
plot_stacked_bars(ax1, counts_election_2021, roles, colors)
ax1.set_title(title_election_2021, y=1.2)
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value)
ax1.invert_yaxis()  # Invert y-axis to match the picture
ax1.grid(True, alpha=0.7, linestyle='--')  # Add grid lines with style
ax1.set_xlim(*xlim_value)
ax1.tick_params(axis="y", which="both", length=0)
ax1.tick_params(axis="x", which="both", color="gray")

# Plot for Election 2022
plot_stacked_bars(ax2, counts_election_2022, roles, colors)
ax2.set_title(title_election_2022)
ax2.set_xlabel(xlabel_value)
ax2.set_ylabel(ylabel_value)
ax2.set_xlim(*xlim_value)
ax2.invert_yaxis()  # Invert y-axis to match the picture
ax2.grid(True, alpha=0.7, linestyle='--')  # Add grid lines with style
ax2.tick_params(axis="y", which="both", length=0)
ax2.tick_params(axis="x", which="both", color="gray")

# Legend
ax1.legend(
    legend_labels,
    bbox_to_anchor=(0.5, 1.2),
    loc="upper center",
    ncol=3,
    frameon=False,
)

# Set x-axis ticks after all plots
ax1.set_xticks(xticks_value)
ax2.set_xticks(xticks_value)
ax1.tick_params(axis="x", which="both", bottom=True, top=False, labelbottom=True)

# Title for the whole figure
fig.suptitle(fig_title, fontsize=fontsize_title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_128.pdf", bbox_inches="tight")
