
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
sports = ["Soccer", "Basketball", "Tennis", "Swimming", "Running"]
Player_A = [85, 90, 75, 65, 70]
Player_B = [70, 78, 82, 60, 75]
Player_C = [88, 85, 80, 70, 85]
Player_D = [78, 80, 65, 75, 80]
Player_E = [75, 83, 70, 68, 78]

# Plot labels
xlabel = "Sports"
ylabel = "Performance (%)"
title = "Player Performance Across Different Sports"

# Legend labels
Player_A_label = "Player A"
Player_B_label = "Player B"
Player_C_label = "Player C"
Player_D_label = "Player D"
Player_E_label = "Player E"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
barWidth = 0.16
xticks = [r + barWidth * 2 for r in range(len(Player_A))]
xtickslabel = sports
yticks = [50, 60, 70, 80, 90, 100]
ytickslabel = None
xlim = None
ylim = (50, 100)

# Set figure size
plt.figure(figsize=(10, 5))

# Set position of bar on X axis
r1 = np.arange(len(Player_A))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

# Make the plot
plt.bar(
    r1,
    Player_A,
    color="#6a994e",
    width=barWidth,
    edgecolor="white",
    label=Player_A_label,
)
plt.bar(
    r2,
    Player_B,
    color="#4ea8de",
    width=barWidth,
    edgecolor="white",
    label=Player_B_label,
)
plt.bar(
    r3,
    Player_C,
    color="#f77f00",
    width=barWidth,
    edgecolor="white",
    label=Player_C_label,
)
plt.bar(
    r4,
    Player_D,
    color="#9d4edd",
    width=barWidth,
    edgecolor="white",
    label=Player_D_label,
)
plt.bar(
    r5, Player_E, color="#ffb4a2", width=barWidth, edgecolor="white", label=Player_E_label
)

# Add labels
for i in range(len(sports)):
    plt.text(
        r1[i],
        Player_A[i] + 1,
        str(Player_A[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r2[i],
        Player_B[i] + 1,
        str(Player_B[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r3[i],
        Player_C[i] + 1,
        str(Player_C[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r4[i],
        Player_D[i] + 1,
        str(Player_D[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r5[i], Player_E[i] + 1, str(Player_E[i]), ha="center", fontsize=8, rotation=45
    )

# Add xticks on the middle of the group bars
plt.xlabel(xlabel, fontsize=12)
plt.xticks(xticks, xtickslabel)

# Create legend & Show graphic
plt.ylabel(ylabel, fontsize=12)
plt.ylim(ylim)
plt.yticks(yticks)
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), frameon=False, ncol=5)

plt.tick_params(axis="x", which="both", length=0)
plt.tick_params(axis="y", color="gray")

# Add y grid
plt.gca().yaxis.grid(True)
plt.gca().set_axisbelow(True)

# Remove top and right borders
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(False)
plt.gca().spines["left"].set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_129.pdf", bbox_inches="tight")
