
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
categories = ["Electric Vehicles", "SUVs", "Sedans", "Trucks", "Average"]
Brand_A = [25.4, 45.8, 32.7, 28.9, 33.2]
Brand_B = [22.1, 43.3, 30.0, 29.5, 31.2]
Brand_C = [23.0, 48.0, 28.5, 32.1, 32.9]
Brand_D = [20.5, 46.2, 29.0, 31.5, 31.8]
Brand_E = [26.7, 44.1, 27.8, 30.8, 32.4]

# Plot labels
xlabel = "Vehicle Categories"
ylabel = "Sales (in thousands)"
title = "Vehicle Sales by Category and Brand"

# Legend labels
Brand_A_label = "Brand A"
Brand_B_label = "Brand B"
Brand_C_label = "Brand C"
Brand_D_label = "Brand D"
Brand_E_label = "Brand E"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
barWidth = 0.16
xticks = [r + barWidth * 2 for r in range(len(Brand_A))]
xtickslabel = categories
yticks = [10, 20, 30, 40, 50, 60]
ytickslabel = None
xlim = None
ylim = (10, 60)

# Set figure size
plt.figure(figsize=(12, 6))

# Set position of bar on X axis
r1 = np.arange(len(Brand_A))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

# Make the plot
plt.bar(
    r1,
    Brand_A,
    color="#4C72B0",
    width=barWidth,
    edgecolor="gray",
    label=Brand_A_label,
)
plt.bar(
    r2,
    Brand_B,
    color="#55A868",
    width=barWidth,
    edgecolor="gray",
    label=Brand_B_label,
)
plt.bar(
    r3,
    Brand_C,
    color="#C44E52",
    width=barWidth,
    edgecolor="gray",
    label=Brand_C_label,
)
plt.bar(
    r4,
    Brand_D,
    color="#8172B3",
    width=barWidth,
    edgecolor="gray",
    label=Brand_D_label,
)
plt.bar(
    r5, Brand_E, color="#CCB974", width=barWidth, edgecolor="gray", label=Brand_E_label
)

# Add labels
for i in range(len(categories)):
    plt.text(
        r1[i],
        Brand_A[i] + 1,
        str(Brand_A[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r2[i],
        Brand_B[i] + 1,
        str(Brand_B[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r3[i],
        Brand_C[i] + 1,
        str(Brand_C[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r4[i],
        Brand_D[i] + 1,
        str(Brand_D[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r5[i], Brand_E[i] + 1, str(Brand_E[i]), ha="center", fontsize=8, rotation=45
    )

# Add xticks on the middle of the group bars
plt.xlabel(xlabel, fontsize=12)
plt.xticks(xticks, xtickslabel)

# Create legend & Show graphic
plt.ylabel(ylabel, fontsize=12)
plt.ylim(ylim)
plt.yticks(yticks)
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), frameon=False, ncol=5)

# Add y grid
plt.gca().yaxis.grid(True)
plt.gca().set_axisbelow(True)

# Remove top and right borders
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_130.pdf", bbox_inches="tight")
