
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
seasons = ["Winter", "Spring", "Summer", "Fall"]
Temp_2018 = [5, 12, 22, 15]
Temp_2019 = [4, 11, 24, 14]
Temp_2020 = [3, 13, 23, 16]
Temp_2021 = [6, 14, 25, 17]
Temp_2022 = [7, 15, 26, 18]

barWidth = 0.15
r1 = np.arange(len(Temp_2018))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

labels = ["2018", "2019", "2020", "2021", "2022"]
ylabel = "Average Temperature (°C)"
xlabel = "Seasons"
title = "Average Seasonal Temperatures Over Years"
legendlabels = ["2018", "2019", "2020", "2021", "2022"]
ylim = [0, 30]
yticks = [0, 5, 10, 15, 20, 25, 30]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure
plt.figure(figsize=(10, 6))  # Adjusted dimensions

# Create bars with new color scheme
plt.bar(r1, Temp_2018, color="#004c6d", width=barWidth, edgecolor="black", label=legendlabels[0])
plt.bar(r2, Temp_2019, color="#1f78b4", width=barWidth, edgecolor="black", label=legendlabels[1])
plt.bar(r3, Temp_2020, color="#a6cee3", width=barWidth, edgecolor="black", label=legendlabels[2])
plt.bar(r4, Temp_2021, color="#fdbf6f", width=barWidth, edgecolor="black", label=legendlabels[3])
plt.bar(r5, Temp_2022, color="#e31a1c", width=barWidth, edgecolor="black", label=legendlabels[4])

# Add xticks on the middle of the group bars
plt.xticks([r + barWidth * 2 for r in range(len(Temp_2018))], seasons)

# Create legend & Show graphic
plt.legend(loc="upper left")
plt.ylabel(ylabel)
plt.xlabel(xlabel)
plt.title(title)
plt.ylim(ylim)
plt.yticks(yticks)
plt.grid(axis='y', linestyle='--', linewidth=0.7, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_134.pdf", bbox_inches="tight")
