
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New Dataset for Technology Domain
categories = [
    "Model A vs. Model B",
    "Model A vs. Model C",
    "Model A vs. Model D",
    "Model A vs. Model E",
    "Model B vs. Model C",
    "Model B vs. Model D",
    "Model B vs. Model E",
    "Model C vs. Model D",
]

# New plausible win, tie, lose data
model_win = [55.2, 48.1, 60.3, 52.0, 47.5, 51.3, 43.0, 58.7]
tie = [30.2, 35.0, 25.7, 33.0, 36.2, 30.0, 40.0, 30.0]
model_lose = [14.6, 16.9, 14.0, 15.0, 16.3, 18.7, 17.0, 11.3]

# Text contents
textcontent = "Model Performance Comparison on Various Benchmarks"
suptitle = "Comparison of Different Machine Learning Models"
legendlabels = ["Model win", "Tie", "Model lose"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

# Plot
fig, ax = plt.subplots(figsize=(10, 8))

bar_width = 0.5  # Adjusted bar width for readability
bar_spacing = 0.1  # Adjusted spacing between bars

for i, category in enumerate(categories):
    ax.barh(category, model_win[i], height=bar_width, color=colors[0])
    ax.barh(category, tie[i], height=bar_width, left=model_win[i], color=colors[1])
    ax.barh(
        category,
        model_lose[i],
        height=bar_width,
        left=model_win[i] + tie[i],
        color=colors[2],
    )
    ax.text(
        5,
        category,
        f"{model_win[i]}%",
        ha="center",
        va="center",
        color="white",
        fontsize=10,
    )
    ax.text(
        model_win[i] + tie[i] / 2,
        category,
        f"{tie[i]}%",
        ha="center",
        va="center",
        color="white",
        fontsize=10,
    )
    ax.text(
        95,
        category,
        f"{model_lose[i]}%",
        ha="center",
        va="center",
        color="white",
        fontsize=10,
    )

# Remove spines
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)
ax.spines["bottom"].set_visible(False)
ax.spines["left"].set_visible(False)

# Remove x-axis
ax.xaxis.set_visible(False)

# Adjust y-axis
ax.invert_yaxis()

# Add label below the x-axis
plt.figtext(
    0.5,
    0.01,
    textcontent,
    ha="center",
    fontsize=10,
)

# Add Suptitle
plt.suptitle(suptitle, fontsize=14)

# Legend
ax.legend(
    legendlabels,
    loc="upper center",
    ncol=3,
    fontsize=12,
    bbox_to_anchor=(0.5, 1.1),
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_135.pdf", bbox_inches="tight")
