
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = ["Fiction", "Non-Fiction", "Sci-Fi", "Fantasy", "Mystery"]
readers_choice_wins = [75, 60, 80, 70, 65]
tie = [15, 25, 10, 20, 25]
critics_choice_wins = [10, 15, 10, 10, 10]
indices = range(len(categories))

# Labels
labels = ["Reader's Choice Wins", "Tie", "Critics' Choice Wins"]
xlabel = "Number of Awards"
ylabel = "Book Genres"
title = "Awards Distribution Across Book Genres"
supertitle = "Literature Awards Analysis"
annotation_texts = [readers_choice_wins, tie, critics_choice_wins]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
bar_width = 0.5
colors = ["#b5651d", "#f4a460", "#d2b48c"]

# Figure size
fig, ax = plt.subplots(figsize=(10, 6))

# Bar chart
bars1 = ax.barh(indices, readers_choice_wins, bar_width, label=labels[0], color=colors[0])
bars2 = ax.barh(indices, tie, bar_width, left=readers_choice_wins, label=labels[1], color=colors[1])
bars3 = ax.barh(indices, critics_choice_wins, bar_width, left=[i + j for i, j in zip(readers_choice_wins, tie)], label=labels[2], color=colors[2])

# Adding text labels
for i, bar in enumerate(bars1):
    ax.text(bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{readers_choice_wins[i]}", ha="center", va="center", color="white", fontsize=12)
for i, bar in enumerate(bars2):
    ax.text(bar.get_x() + bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{tie[i]}", ha="center", va="center", color="black", fontsize=12)
for i, bar in enumerate(bars3):
    ax.text(bar.get_x() + bar.get_width() / 2, bar.get_y() + bar.get_height() / 2, f"{critics_choice_wins[i]}", ha="center", va="center", color="black", fontsize=12)

# Labels and title
ax.set_yticks(indices)
ax.set_yticklabels(categories, fontsize=14)
ax.invert_yaxis()  # Labels read top-to-bottom
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16)

# Legend
ax.legend(loc="upper left", bbox_to_anchor=(0.1, 1.17), ncol=3, fontsize=14)

# Supertitle
plt.suptitle(supertitle, fontsize=18)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_139.pdf", bbox_inches="tight")
