
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# New Data for Entertainment Domain
np.random.seed(0)
audience_engagement_data = {
    "Audience Engagement": [25.0, 35.0, 15.0, 10.0, 15.0],
    "Revenue": [10.0, 25.0, 30.0, 20.0, 15.0],
    "Critical Reception": [5.0, 20.0, 40.0, 25.0, 10.0],
    "Popularity": [15.0, 30.0, 25.0, 20.0, 10.0],
}
audience_engagement_data2 = {
    "Effort Required": [20.0, 25.0, 20.0, 25.0, 10.0]
}

streaming_platform_data = {
    "Audience Engagement": [30.0, 20.0, 25.0, 15.0, 10.0],
    "Revenue": [15.0, 30.0, 25.0, 20.0, 10.0],
    "Critical Reception": [5.0, 15.0, 40.0, 30.0, 10.0],
    "Popularity": [10.0, 20.0, 35.0, 25.0, 10.0],
}
streaming_platform_data2 = {"Effort Required": [25.0, 20.0, 20.0, 25.0, 10.0]}

categories = ["Strong Disagree", "Disagree", "Neutral", "Agree", "Strongly Agree"]
categories2 = ["Very Low", "Low", "Neutral", "High", "Very High"]

labels = ["Audience Engagement", "Streaming Platform"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
new_colors = ["#ff9999","#66b3ff","#99ff99","#ffcc99","#c2c2f0"]
xlim = [-69, 69]
xticks = np.arange(-60, 61, 20)
# Create a gridspec
gs = gridspec.GridSpec(
    3, 2, height_ratios=[1.2, 0.2, 0.2]
)  # Adjust the height ratios for each row

fig = plt.figure(figsize=(12, 8))

# Create axes using the gridspec
axes = [plt.subplot(gs[0, 0]), plt.subplot(gs[0, 1])]

def create_bar_chart(ax, results, category_names, title):

    labels = list(results.keys())
    data = np.array(list(results.values()))
    data_cum = data.cumsum(axis=1)
    middle_index = data.shape[1] // 2
    offsets = data[:, range(middle_index)].sum(axis=1) + data[:, middle_index] / 2

    # Color Mapping
    category_colors = plt.get_cmap("tab20c")(np.linspace(0.15, 0.85, data.shape[1]))

    # Plot Bars
    for i, (colname, color) in enumerate(zip(category_names, category_colors)):
        widths = data[:, i]
        starts = data_cum[:, i] - widths - offsets
        rects = ax.barh(
            labels,
            widths,
            left=starts,
            height=0.5,
            label=colname,
            color=color,
            edgecolor="black",
        )
        for j, (start, width) in enumerate(zip(starts, widths)):
            # Calculate the center position of each bar segment for the text
            text_x = start + width / 2
            text_y = j  # y-coordinate is based on the bar's index (j)
            ax.text(
                text_x,
                text_y,
                f"{abs(width):.1f}%",
                va="center",
                ha="center",
                color="black",
                fontsize=8,
            )
    # Add Zero Reference Line
    ax.axvline(0, linestyle="-", color="black", alpha=0.25)
    # X Axis
    ax.set_xlim(xlim)
    ax.set_xticks(xticks)
    ax.xaxis.set_major_formatter(lambda x, pos: str(abs(int(x))))
    # Y Axis
    ax.invert_yaxis()
    ax.set_title(title, fontsize=15)


# Create bar charts for Entertainment Data
create_bar_chart(axes[0], audience_engagement_data, categories, labels[0])
create_bar_chart(axes[1], streaming_platform_data, categories2, labels[1])


# Add legend
handles, labels = axes[0].get_legend_handles_labels()
fig.legend(
    handles,
    labels,
    loc="lower center",
    ncol=len(categories),
    bbox_to_anchor=(0.5, 0.25),
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_142.pdf", bbox_inches="tight")
