
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Patient Satisfaction - Hospital A
hospital_a_data = {
    "Quality of Care": [15, 25, 30, 20, 10],
    "Timeliness": [10, 20, 35, 25, 10],
    "Communication": [8, 22, 40, 20, 10],
    "Facility Cleanliness": [12, 28, 35, 15, 10],
}
hospital_a_data2 = {
    "Overall Satisfaction": [18, 30, 25, 17, 10],
}

# Data for Patient Satisfaction - Hospital B
hospital_b_data = {
    "Quality of Care": [20, 20, 30, 20, 10],
    "Timeliness": [15, 25, 30, 20, 10],
    "Communication": [12, 18, 40, 20, 10],
    "Facility Cleanliness": [10, 25, 40, 15, 10],
}
hospital_b_data2 = {"Overall Satisfaction": [20, 25, 30, 15, 10]}

categories = ["Very Unsatisfied", "Unsatisfied", "Neutral", "Satisfied", "Very Satisfied"]
categories2 = ["Very Low", "Low", "Neutral", "High", "Very High"]

labels = ["Hospital A", "Hospital B"]

# Chart text labels
title_a = "Patient Satisfaction - Hospital A"
title_b = "Patient Satisfaction - Hospital B"
legend_labels = ["Very Unsatisfied", "Unsatisfied", "Neutral", "Satisfied", "Very Satisfied"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#67a9cf", "#ef8a62", "white", "#67a9cf", "#2166ac"]
xlim = [-60, 60]
xticks = np.arange(-50, 51, 20)

# Create a gridspec
gs = gridspec.GridSpec(
    3, 2, height_ratios=[1.2, 0.2, 0.2]
)  # Adjust the height ratios for each row

fig = plt.figure(figsize=(12, 7))

# Create axes using the gridspec
axes = [plt.subplot(gs[0, 0]), plt.subplot(gs[0, 1])]


def create_bar_chart(ax, results, category_names, title):

    labels = list(results.keys())
    data = np.array(list(results.values()))
    data_cum = data.cumsum(axis=1)
    middle_index = data.shape[1] // 2
    offsets = data[:, range(middle_index)].sum(axis=1) + data[:, middle_index] / 2

    # Color Mapping
    category_colors = plt.get_cmap("viridis")(np.linspace(0.15, 0.85, data.shape[1]))

    # Plot Bars
    for i, (colname, color) in enumerate(zip(category_names, category_colors)):
        widths = data[:, i]
        starts = data_cum[:, i] - widths - offsets
        rects = ax.barh(
            labels,
            widths,
            left=starts,
            height=0.5,
            label=colname,
            color=color,
            edgecolor="black",
        )
        for j, (start, width) in enumerate(zip(starts, widths)):
            # Calculate the center position of each bar segment for the text
            text_x = start + width / 2
            text_y = j  # y-coordinate is based on the bar's index (j)
            ax.text(
                text_x,
                text_y,
                f"{abs(width):.1f}%",
                va="center",
                ha="center",
                color="black",
                fontsize=8,
            )
    # Add Zero Reference Line
    ax.axvline(0, linestyle="-", color="black", alpha=0.25)
    # X Axis
    ax.set_xlim(xlim)
    ax.set_xticks(xticks)
    ax.xaxis.set_major_formatter(lambda x, pos: str(abs(int(x))))
    # Y Axis
    ax.invert_yaxis()
    ax.set_title(title)


# Create bar charts for Hospital A and Hospital B
create_bar_chart(axes[0], hospital_a_data, categories, title_a)
create_bar_chart(axes[1], hospital_b_data, categories2, title_b)


# Add legend
handles, labels = axes[0].get_legend_handles_labels()
fig.legend(
    handles,
    labels,
    loc="lower center",
    ncol=len(categories),
    bbox_to_anchor=(0.5, 0.25),
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_143.pdf", bbox_inches="tight")
