
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
models = ["iPhone 14", "Samsung Galaxy S22", "Google Pixel 7", "OnePlus 10", "Sony Xperia 1", "Xiaomi Mi 12"]
battery_life = [4.0, 3.7, 3.8, 3.9, 3.5, 3.8]
camera_quality = [4.2, 4.0, 4.1, 3.8, 4.0, 3.9]
performance = [4.5, 4.3, 4.4, 4.1, 4.2, 4.0]
design = [4.1, 4.0, 3.9, 4.2, 4.0, 3.7]

x = np.arange(len(models))  # the label locations

labels = ["Battery Life", "Camera Quality", "Performance", "Design"]
ylabel = "Ratings"
xlabel = "Smartphone Models"
title = "Ratings of Smartphone Models on a Scale from 1-5"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.2  # the width of the bars
fig, ax = plt.subplots(figsize=(10, 6))

# Color scheme for technology domain
colors = ["#8c564b", "#2ca02c", "#1f77b4", "#ff7f0e"]

# Plotting
rects1 = ax.bar(x - width * 1.5, battery_life, width, label=labels[0], color=colors[0])
rects2 = ax.bar(x - width / 2, camera_quality, width, label=labels[1], color=colors[1])
rects3 = ax.bar(x + width / 2, performance, width, label=labels[2], color=colors[2])
rects4 = ax.bar(x + width * 1.5, design, width, label=labels[3], color=colors[3])

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel, fontsize=12)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xticks(x)
ax.set_xticklabels(models, rotation=15, ha='right', fontsize=10)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_147.pdf", bbox_inches="tight")
