
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
companies = [
    "Company A",
    "Company B",
    "Company C",
    "Company D",
    "Company E",
    "Company F",
    "Company G",
    "Company H",
]
revenue = [25.4, 37.8, 45.3, 60.5, 55.1, 42.7, 30.3, 49.8]

xlabel = "Companies"
ylabel = "Revenue (in million $)"
title = "Quarterly Revenue of Different Companies"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#2e8b57",
    "#556b2f",
    "#8fbc8f",
    "#4682b4",
    "#7b68ee",
    "#6a5acd",
    "#dda0dd",
    "#ba55d3",
]
xticks = np.arange(len(companies))
ylim = [0, 70]
# Create figure and bar chart
fig, ax = plt.subplots(figsize=(10, 6))
bars = ax.bar(companies, revenue, color=colors, edgecolor='black')

# Add revenue values on top of the bars
for bar in bars:
    yval = bar.get_height()
    plt.text(
        bar.get_x() + bar.get_width() / 2,
        yval + 1,  # Offset text a little above the bar
        round(yval, 1),
        ha="center",
        va="bottom",
        fontsize=10,
        fontweight='bold'
    )

# Set axis labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xticks(xticks)
ax.set_xticklabels(companies, rotation=45, ha="right")

ax.set_ylim(ylim)
ax.grid(True, which='both', linestyle='--', linewidth=0.5, color='gray', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_150.pdf", bbox_inches="tight")
