
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation and Text
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = ["Party A", "Party B", "Party C", "Party D"]
wins = [52, 30, 18, 45]
ties = [20, 25, 30, 20]
losses = [28, 45, 52, 35]

wins2 = [55, 28, 20, 40]
ties2 = [18, 22, 27, 25]
losses2 = [27, 50, 53, 35]

indices = np.arange(len(categories))

xlabel = "Election 2022 (Judge A)"
xlabel2 = "Election 2022 (Judge B)"

labels = [
    "Party A - Wins",
    "Party B - Wins",
    "Party C - Wins",
    "Party D - Wins",
    "Party A - Ties",
    "Party B - Ties",
    "Party C - Ties",
    "Party D - Ties",
    "Party A - Losses",
    "Party B - Losses",
    "Party C - Losses",
    "Party D - Losses",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define colors
colors_wins = ["#E94E77", "#6192C7", "#77C29A", "#FFC107"]
colors_ties = ["#F7A9A8", "#A9C6E8", "#C6E7B5", "#FFECB3"]
colors_losses = ["#F6D2D0", "#D5E2F4", "#E8F5E2", "#FFF3CD"]

# Plot data
bar_width = 0.5

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Function to plot bars
def plot_bars(ax, wins, ties, losses, colors_wins, colors_ties, colors_losses):
    for i, (win, tie, loss) in enumerate(zip(wins, ties, losses)):
        ax.barh(i, win, bar_width, color=colors_wins[i], edgecolor="white")
        ax.barh(i, tie, bar_width, left=win, color=colors_ties[i], edgecolor="white")
        ax.barh(
            i,
            loss,
            bar_width,
            left=win + tie,
            color=colors_losses[i],
            edgecolor="white",
        )
        ax.text(win / 2, i, f"{win}", ha="center", va="center", color="white")
        ax.text(win + tie / 2, i, f"{tie}", ha="center", va="center", color="black")
        ax.text(
            win + tie + loss / 2, i, f"{loss}", ha="center", va="center", color="black"
        )

plot_bars(ax1, wins, ties, losses, colors_wins, colors_ties, colors_losses)

# Set labels, title, and legend for ax1
ax1.set_yticks(indices)
ax1.set_yticklabels(categories)
ax1.invert_yaxis()  # labels read top-to-bottom
ax1.set_xlabel(xlabel)
ax1.set_xticks([])

plot_bars(ax2, wins2, ties2, losses2, colors_wins, colors_ties, colors_losses)
# Set labels, title, and legend for ax2
ax2.set_yticks(indices)
ax2.set_yticklabels(categories)
ax2.invert_yaxis()  # labels read top-to-bottom
ax2.set_xlabel(xlabel2)
ax2.set_xticks([])

# Adjust layout and set background color
fig.patch.set_facecolor("white")
for ax in [ax1, ax2]:
    ax.set_facecolor("white")
    ax.spines["top"].set_edgecolor("gray")
    ax.spines["right"].set_edgecolor("gray")
    ax.spines["bottom"].set_edgecolor("gray")
    ax.spines["left"].set_edgecolor("gray")

# Create a global legend
patch1 = mpatches.Patch(color="#E94E77", label=labels[0])
patch2 = mpatches.Patch(color="#6192C7", label=labels[1])
patch3 = mpatches.Patch(color="#77C29A", label=labels[2])
patch4 = mpatches.Patch(color="#FFC107", label=labels[3])
patch5 = mpatches.Patch(color="#F7A9A8", label=labels[4])
patch6 = mpatches.Patch(color="#A9C6E8", label=labels[5])
patch7 = mpatches.Patch(color="#C6E7B5", label=labels[6])
patch8 = mpatches.Patch(color="#FFECB3", label=labels[7])
patch9 = mpatches.Patch(color="#F6D2D0", label=labels[8])
patch10 = mpatches.Patch(color="#D5E2F4", label=labels[9])
patch11 = mpatches.Patch(color="#E8F5E2", label=labels[10])
patch12 = mpatches.Patch(color="#FFF3CD", label=labels[11])
fig.legend(
    handles=[patch1, patch2, patch3, patch4, patch5, patch6, patch7, patch8, patch9, patch10, patch11, patch12],
    loc="upper center",
    ncol=4,
    bbox_to_anchor=(0.5, 1.1),
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_153.pdf", bbox_inches="tight")
