
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
categories = ["Region A", "Region B", "Region C", "Region D"]
wins = [85.1, 75.3, 68.9, 80.4]
ties = [10.2, 15.8, 20.0, 14.1]
losses = [4.7, 8.9, 11.1, 5.5]

# Repeat for the second subplot with different data
wins2 = [83.6, 74.5, 69.8, 78.9]
ties2 = [12.4, 16.3, 19.5, 13.8]
losses2 = [4.0, 9.2, 10.7, 7.3]

indices = np.arange(len(categories))

xlabel = "Year 2022 Yields"
xlabel2 = "Year 2023 Yields"

labels = [
    "High Yields",
    "Moderate Yields",
    "Consistent Yields",
    "Fluctuating Yields",
    "Low Yields",
    "Very Low Yields",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define colors
colors_wins = ["#4CAF50", "#4CAF50", "#4CAF50", "#FF9800"]
colors_ties = ["#81C784", "#81C784", "#81C784", "#FFB74D"]
colors_losses = ["#C8E6C9", "#C8E6C9", "#C8E6C9", "#FFCC80"]

# Plot data
bar_width = 0.5

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Function to plot bars
def plot_bars(ax, wins, ties, losses, colors_wins, colors_ties, colors_losses):
    for i, (win, tie, loss) in enumerate(zip(wins, ties, losses)):
        ax.barh(i, win, bar_width, color=colors_wins[i], edgecolor="white")
        ax.barh(i, tie, bar_width, left=win, color=colors_ties[i], edgecolor="white")
        ax.barh(
            i,
            loss,
            bar_width,
            left=win + tie,
            color=colors_losses[i],
            edgecolor="white",
        )
        ax.text(win / 2, i, f"{win}%", ha="center", va="center", color="white")
        ax.text(win + tie / 2, i, f"{tie}%", ha="center", va="center", color="black")
        ax.text(
            win + tie + loss / 2, i, f"{loss}%", ha="center", va="center", color="black"
        )

plot_bars(ax1, wins, ties, losses, colors_wins, colors_ties, colors_losses)

# Set labels, title, and legend for ax1
ax1.set_yticks(indices)
ax1.set_yticklabels(categories)
ax1.invert_yaxis()  # labels read top-to-bottom
ax1.set_xlabel(xlabel)
ax1.set_xticks([])

plot_bars(ax2, wins2, ties2, losses2, colors_wins, colors_ties, colors_losses)

# Set labels, title, and legend for ax2
ax2.set_yticks(indices)
ax2.set_yticklabels(categories)
ax2.invert_yaxis()  # labels read top-to-bottom
ax2.set_xlabel(xlabel2)
ax2.set_xticks([])

# Adjust layout and set background color
fig.patch.set_facecolor("white")
for ax in [ax1, ax2]:
    ax.set_facecolor("white")
    ax.spines["top"].set_edgecolor("gray")
    ax.spines["right"].set_edgecolor("gray")
    ax.spines["bottom"].set_edgecolor("gray")
    ax.spines["left"].set_edgecolor("gray")

# Create a global legend
patch1 = mpatches.Patch(color="#FF9800", label=labels[0])
patch2 = mpatches.Patch(color="#4CAF50", label=labels[1])
patch3 = mpatches.Patch(color="#FFB74D", label=labels[2])
patch4 = mpatches.Patch(color="#81C784", label=labels[3])
patch5 = mpatches.Patch(color="#FFCC80", label=labels[4])
patch6 = mpatches.Patch(color="#C8E6C9", label=labels[5])
fig.legend(
    handles=[patch1, patch2, patch3, patch4, patch5, patch6],
    loc="upper center",
    ncol=3,
    bbox_to_anchor=(0.5, 1.1),
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_154.pdf", bbox_inches="tight")
