# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
emotions = ["Ang", "Cnt", "Dis", "Fea", "Joy", "Ntr", "Sad", "Sur"]
negative = [500, 300, 200, 1000, 0, 0, 500, 0]
positive = [0, 0, 0, 0, 2000, 0, 0, 0]
none = [0, 0, 0, 0, 0, 3500, 0, 0]
mixed = [0, 0, 0, 0, 0, 0, 0, 300]
# Updated education-related labels
labels = ["Elementary", "Middle School", "High School", "College"]
xlabel = "Emotions"
ylabel = "Frequency"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = [0, 4000]

# Set figure size to match the original image's dimensions
plt.figure(figsize=(6, 4))

# Plotting
bar_width = 0.8
index = np.arange(len(emotions))

plt.bar(index, negative, bar_width, color="#FF9999", label=labels[0])  # 用较浅的红色
plt.bar(index, positive, bar_width, color="#8FD9B6", label=labels[1], bottom=negative)  # 使用绿松石色
plt.bar(
    index,
    none,
    bar_width,
    color="#CCCCCC",  # 使用灰色
    label=labels[2],
    bottom=[i + j for i, j in zip(negative, positive)],
)
plt.bar(
    index,
    mixed,
    bar_width,
    color="#FFD700",  # 使用金色
    label=labels[3],
    bottom=[i + j + k for i, j, k in zip(negative, positive, none)],
)

# Labels and Title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.ylim(ylim)
plt.xticks(index, emotions)
plt.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_156.pdf", bbox_inches="tight")
