# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
art_styles = ["Abstract", "Impressionism", "Baroque", "Renaissance", "Surrealism", "Cubism", "Modern", "Pop Art"]
primary_colors = [150, 200, 100, 0, 0, 0, 0, 0]
monochrome = [0, 0, 0, 50, 40, 0, 0, 0]
complementary = [0, 0, 0, 0, 0, 90, 60, 0]
mixed_colors = [0, 0, 0, 0, 0, 0, 0, 160]
labels = ["Primary Colors", "Monochrome", "Complementary", "Mixed Colors"]
xlabel = "Art Styles"
ylabel = "Frequency"
title = "Distribution of Color Schemes in Famous Paintings"
ylim = [0, 800]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(10, 6))

# Plotting
bar_width = 0.8
index = np.arange(len(art_styles))

# Updated colors
colors = ["#1f77b4", "#aec7e8", "#ff7f0e", "#ffbb78"]

plt.bar(index, primary_colors, bar_width, color=colors[0], label=labels[0])
plt.bar(index, monochrome, bar_width, color=colors[1], label=labels[1], bottom=primary_colors)
plt.bar(index, complementary, bar_width, color=colors[2], label=labels[2], bottom=[i + j for i, j in zip(primary_colors, monochrome)])
plt.bar(index, mixed_colors, bar_width, color=colors[3], label=labels[3], bottom=[i + j + k for i, j, k in zip(primary_colors, monochrome, complementary)])

# Labels and Title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.ylim(ylim)
plt.title(title)
plt.xticks(index, art_styles)
plt.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_157.pdf", bbox_inches="tight")
