
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
datasets = ["January", "July"]
coal = [500, 450]
solar = [300, 600]
wind = [200, 350]

# X-axis positions
x = np.arange(len(datasets))


labels = ["Coal", "Solar", "Wind"]

ylabel = "Energy Consumption (GWh)"
xlabel = "Months"
title = "Monthly Energy Consumption by Source"
legend_labels = ["Coal", "Solar", "Wind"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
width = 0.2
ylim = [0, 700]


# Plotting
fig, ax = plt.subplots(
    figsize=(8, 6)
)  # Adjusting figure size to be larger for better readability
ax.bar(
    x - width,
    coal,
    width,
    label=labels[0],
    hatch="//",
    edgecolor="black",
    color="darkgray",
)
ax.bar(
    x,
    solar,
    width,
    label=labels[1],
    hatch="..",
    edgecolor="black",
    color="yellow",
)
ax.bar(
    x + width,
    wind,
    width,
    label=labels[2],
    hatch="xx",
    edgecolor="black",
    color="green",
)

# Labels and Title
ax.set_ylim(ylim)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_xticks(x)
ax.set_xticklabels(datasets)
ax.legend(loc="upper left", title="Energy Source")

# Title
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_163.pdf", bbox_inches="tight")
