
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New data: Energy consumption (TWh) by sector
sectors = ["Industrial", "Transportation", "Residential", "Commercial", "Agriculture"]
coal = [120, 80, 50, 30, 20]
natural_gas = [90, 100, 70, 60, 10]
renewables = [60, 20, 100, 40, 50]

x = np.arange(len(sectors))  # the label locations

# Labels for legend
label_coal = "Coal"
label_natural_gas = "Natural Gas"
label_renewables = "Renewables"

# Axis labels
xlabel = "Sectors"
ylabel = "Energy Consumption (TWh)"

# Chart Title
title = "Annual Energy Consumption by Sector"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.25  # the width of the bars
# Axis ticks
xticks = x
yticks = [0, 50, 100, 150]

# Axis tick labels
xticklabels = sectors
yticklabels = ["0", "50", "100", "150"]

fig, ax = plt.subplots(figsize=(10, 6))
rects1 = ax.bar(x - width, coal, width, label=label_coal, color="#707070")
rects2 = ax.bar(x, natural_gas, width, label=label_natural_gas, color="#1f77b4")
rects3 = ax.bar(x + width, renewables, width, label=label_renewables, color="#2ca02c")

ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_title(title)

# Set custom y-ticks and their labels
ax.set_yticks(yticks)
ax.set_yticklabels(yticklabels)

ax.legend(ncol=3, loc="upper center", bbox_to_anchor=(0.5, 1.1), frameon=False)

ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_166.pdf", bbox_inches="tight")
