
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
destinations = ["Paris", "Tokyo", "New York"]
scenic_beauty = [85.0, 70.5, 60.0]
cultural_experience = [75.0, 90.0, 65.5]
hospitality = [65.0, 60.0, 85.5]

# X-axis positions
x = np.arange(len(destinations))

# Labels and Titles
labels = ["Scenic Beauty", "Cultural Experience", "Hospitality"]
ylabel = "Satisfaction Rating (%)"
xlabel = "Tourist Destinations"
title = "Tourist Satisfaction Ratings"
legendlabels = labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.2
gap_width = 0.02

# Color scheme
colors = ["#93c47d", "#6fa8dc", "#f6b26b"]

# Plotting bars
fig, ax = plt.subplots(figsize=(8, 6))
rects1 = ax.bar(
    x - bar_width - gap_width, scenic_beauty, bar_width, label=labels[0], color=colors[0]
)
rects2 = ax.bar(
    x, cultural_experience, bar_width, label=labels[1], color=colors[1]
)
rects3 = ax.bar(
    x + bar_width + gap_width, hospitality, bar_width, label=labels[2], color=colors[2]
)

# Adding text for labels, title, and custom x-axis tick labels
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_xticks(x)
ax.set_xticklabels(destinations)
ax.set_title(title)
ax.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=3)

# Adding data labels inside the bars
def autolabel(rects):
    for rect in rects:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height + 2),
            xytext=(0, 0),  # No offset
            textcoords="offset points",
            ha="center",
            va="center",
            color="black",
            fontsize=8,
        )

autolabel(rects1)
autolabel(rects2)
autolabel(rects3)

# Adjusting the layout and font sizes
ax.tick_params(axis="x", labelsize=10)
ax.tick_params(axis="y", labelsize=10)
ax.xaxis.label.set_size(12)
ax.yaxis.label.set_size(12)
ax.title.set_size(14)

# Adding grid
ax.grid(axis="y", linestyle="--", alpha=0.6)
ax.grid(axis="x", linestyle="--", alpha=0.6)
ax.set_axisbelow(True)

plt.subplots_adjust(bottom=0.2, top=0.92)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_169.pdf", bbox_inches="tight")
