
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Text Labels
xlabel = "Percentage of Comparison Outcomes"
ylabel = "City Comparisons"
title = "Population Growth Comparisons Between Cities"
legend_labels = ["Growth", "Stable", "Decline"]
categories = [
    "City A vs. City B",
    "City A vs. City C",
    "City B vs. City C",
    "City A vs. City D",
    "City B vs. City D",
    "City C vs. City D",
][::-1]
growth = [35.0, 40.0, 33.0, 45.0, 38.0, 29.0][::-1]
stable = [50.0, 45.0, 55.0, 40.0, 47.0, 55.0][::-1]
decline = [15.0, 15.0, 12.0, 15.0, 15.0, 16.0][::-1]

# Bar configuration
bar_width = 0.6
indices = range(len(categories))

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6))  # Adjust figure size

# Colors
colors = ["#4CAF50", "#FFC107", "#F44336"]

bars1 = ax.barh(indices, growth, bar_width, label=legend_labels[0], color=colors[0])
bars2 = ax.barh(indices, stable, bar_width, left=growth, label=legend_labels[1], color=colors[1])
bars3 = ax.barh(indices, decline, bar_width, left=[i + j for i, j in zip(growth, stable)], label=legend_labels[2], color=colors[2])

# Add text labels to the bars
for bars, color in zip([bars1, bars2, bars3], colors):
    for bar in bars:
        width = bar.get_width()
        center = bar.get_x() + width / 2
        ax.text(center, bar.get_y() + bar.get_height() / 2, f"{width:.1f}%", va="center", ha="center", color="black", fontsize=10)

# Set labels and title
ax.set_yticks(indices)
ax.set_yticklabels(categories, ha="right", fontsize=12)

ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Set the x-axis labels
xticks = np.arange(0, 101, 20)
xtickslabel = [str(x) for x in xticks]
ax.set_xticks(xticks)
ax.set_xticklabels(xtickslabel)

# Add legend
ax.legend(loc="upper center", bbox_to_anchor=(0.5, -0.10), shadow=True, ncol=3, frameon=False)

# Remove spines
for spine in ["top", "right"]:
    ax.spines[spine].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_173.pdf", bbox_inches="tight")
