
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = ["Email Support", "Live Chat", "Phone Support"]
values = [0.85, 0.90, 0.78]

# Axes limits, labels, and ticks
xlabel = "Customer Satisfaction Score"
title = "Customer Satisfaction Scores for Different Communication Services"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = np.arange(0, 1.1, 0.1)
xtickslabel = [f"{x:.1f}" if (i % 2 == 0) else "" for i, x in enumerate(xticks)]
# Colors for each bar
colors = ["#FFA07A", "#20B2AA", "#778899"]

# Create horizontal bar chart
plt.figure(figsize=(8, 4))  # Adjusting figure size for better readability
plt.barh(categories, values, color=colors)

# Adding data labels
for index, value in enumerate(values):
    plt.text(value, index, f" {value:.2f}", va="center", color="black", fontweight="bold")

# Adding title and labels
plt.title(title, fontsize=14)
plt.xlabel(xlabel, fontsize=12)
# Apply the xticks and labels
plt.xticks(xticks, xtickslabel)

plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_176.pdf", bbox_inches="tight")
