
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
categories = [
    "Netflix",
    "Hulu",
    "Amazon Prime",
    "Disney+",
    "HBO Max",
    "Apple TV+",
    "Peacock",
    "Paramount+",
    "YouTube TV",
    "Sling TV",
    "fuboTV",
    "Showtime",
    "Starz",
    "Crunchyroll",
    "ESPN+",
    "Discovery+",
    "Acorn TV",
    "BritBox",
    "Shudder",
    "CuriosityStream",
]

# Generate three lists
OriginalContent, LicensedContent, LiveStreams = np.random.dirichlet(np.ones(3), size=len(categories)).T

OriginalContent = OriginalContent * 100
LicensedContent = LicensedContent * 100
LiveStreams = LiveStreams * 100

r = np.arange(len(categories))
labels = ["Original Content", "Licensed Content", "Live Streams"]

# Chart Labels
xlabel = 'Streaming Services'
ylabel = 'Content Distribution (%)'
title = 'Content Distribution Across Streaming Services'
legendlabels = ["Original Content", "Licensed Content", "Live Streams"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked bar chart setup
bar_width = 0.9

# Plot
fig, ax = plt.subplots(figsize=(10, 6))
bar1 = ax.bar(r, OriginalContent, color="#ff9999", edgecolor="#ff4d4d", hatch='//', width=bar_width, label=labels[0])
bar2 = ax.bar(r, LicensedContent, bottom=OriginalContent, color="#66b3ff", edgecolor="#3399ff", hatch='xx', width=bar_width, label=labels[1])
bar3 = ax.bar(r, LiveStreams, bottom=OriginalContent + LicensedContent, color="#99ff99", edgecolor="#33cc33", hatch='..', width=bar_width, label=labels[2])

# Labels, title and legend
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

ax.set_xticks(r)
ax.set_xticklabels(categories, rotation=-45, ha="center")
ax.set_yticks(np.arange(0, 101, 20))
ax.set_ylim(0, 100)
ax.set_yticklabels(["{}%".format(i) for i in range(0, 101, 20)])
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=3)

# Grid lines
ax.yaxis.grid(True, linestyle="--")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_182.pdf", bbox_inches="tight")
