
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
methods = ["Lecture", "Group Study", "Online Course", "Self-learning", "Interactive Session"]
scores_traditional = [3.2, 3.8, 4.1, 2.9, 4.3]
scores_innovative = [4.5, 4.7, 4.8, 3.6, 4.9]

# Labels for legend and plot type
labels = methods

# Limits, labels, and title for the plot
ylim_values = (2.5, 5.0)
ylabel_value = "Effectiveness Score"
title_value = "Comparison of Teaching Methods"
supertitle_value = "Educational Methods Evaluation"
xticks_values = [6, 12]
xtickslabel_values = ["Traditional", "Innovative"]
legend_labels = methods

# Bar width
bar_width = 1
# X-axis positions
r1 = np.arange(len(methods))
r2 = [x + bar_width + len(r1) for x in r1]


# Text labels for bars
traditional_labels = ["3.2", "3.8", "4.1", "2.9", "4.3"]
innovative_labels = ["4.5", "4.7", "4.8", "3.6", "4.9"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 6))
# Colors (using a vibrant, educational color scheme)
colors = ["#FF6347", "#4682B4", "#3CB371", "#FFD700", "#8A2BE2"]

# Create bars for Traditional scores
for i in range(len(r1)):
    plt.bar(
        xticks_values[0] + (i - 2) * bar_width,
        scores_traditional[i],
        color=colors[i],
        width=bar_width,
        edgecolor="white",
        label=labels[i] if i == 0 else ""
    )

# Create bars for Innovative scores
for i in range(len(r2)):
    plt.bar(
        xticks_values[1] + (i - 2) * bar_width,
        scores_innovative[i],
        color=colors[i],
        width=bar_width,
        edgecolor="white",
    )

# Add text on top of the bars
for i in range(len(r1)):
    plt.text(
        xticks_values[0] + (i - 2) * bar_width,
        scores_traditional[i] + 0.05,
        traditional_labels[i],
        ha="center",
    )
    plt.text(
        xticks_values[1] + (i - 2) * bar_width,
        scores_innovative[i] + 0.05,
        innovative_labels[i],
        ha="center",
    )

# Layout and style adjustments
plt.xticks(xticks_values, xtickslabel_values)
plt.ylabel(ylabel_value)
plt.title(title_value)
plt.suptitle(supertitle_value, fontsize=14, fontweight='bold')
plt.ylim(*ylim_values)
plt.legend(legend_labels, loc="upper center", ncol=5, bbox_to_anchor=(0.5, 1.0), frameon=False)

plt.tick_params(axis="x", which="both", length=0)
plt.gca().yaxis.grid(True)
plt.gca().set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 1])
plt.savefig("bar_183.pdf", bbox_inches="tight")
