
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
continents = ["Africa", "Asia", "Europe", "N. America", "S. America"]
scores_org1 = [6.2, 7.5, 6.8, 7.2, 5.9]
scores_org2 = [5.8, 7.0, 6.5, 7.6, 6.1]

index = [6, 12]

# Labels for legend and plot type
labels = continents
# Limits, labels, and title for the plot
ylim_values = (5.0, 8.0)
ylabel_value = "Environmental Index Score"
xticks_values = index
xtickslabel_values = ["Org1", "Org2"]
title_value = "Environmental Scores by Continent"
legendlabels = ["Africa", "Asia", "Europe", "N. America", "S. America"]

# Bar width
bar_width = 1
# X-axis positions
r1 = np.arange(len(continents))
r2 = [x + bar_width + len(r1) for x in r1]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 5))
# Colors inspired by natural elements
colors = ["#66c2a5", "#fc8d62", "#8da0cb", "#e78ac3", "#a6d854"]

# Create bars
for i in range(len(r1)):
    plt.bar(
        index[0] + (i - 2) * bar_width,
        scores_org1[i],
        color=colors[i],
        width=bar_width,
        edgecolor="white",
        label=labels[i],
    )

for i in range(len(r2)):
    plt.bar(
        index[1] + (i - 2) * bar_width,
        scores_org2[i],
        color=colors[i],
        width=bar_width,
        edgecolor="white",
    )

# Add text on top of the bars
for i in range(len(r1)):
    plt.text(
        index[0] + (i - 2) * bar_width,
        scores_org1[i] + 0.05,
        str(scores_org1[i]),
        ha="center",
    )
    plt.text(
        index[1] + (i - 2) * bar_width,
        scores_org2[i] + 0.05,
        str(scores_org2[i]),
        ha="center",
    )

# General layout
plt.xticks(xticks_values, xtickslabel_values)
plt.ylabel(ylabel_value)
plt.ylim(*ylim_values)
plt.legend(legendlabels, loc="upper center", ncol=5, bbox_to_anchor=(0.5, 1.1), frameon=False)
plt.suptitle(title_value)

plt.tick_params(axis="x", which="both", length=0)
plt.gca().yaxis.grid(True)
plt.gca().set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_184.pdf", bbox_inches="tight")
