
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# New Data representing average crop yields (tons per hectare)
methods = ["Traditional", "Organic", "Hydroponic", "Aquaponic", "Vertical Farming"]
yields_region_a = [3.2, 2.8, 4.5, 4.3, 5.0]
yields_region_b = [2.9, 2.7, 4.2, 4.1, 4.6]

# Labels for legend and plot type
labels = methods
# Limits, labels, and title for the plot
ylim_values = (2.0, 6.0)
ylabel_value = "Average Crop Yield (tons/ha)"
xticks_values = [6, 12]
xtickslabel_values = ["Region A", "Region B"]

# Bar width
bar_width = 1
# X-axis positions
r1 = np.arange(len(methods))
r2 = [x + bar_width + len(r1) for x in r1]


# Titles and labels
title_text = "Comparison of Average Crop Yield by Farming Methods"
supertitle_text = "Agricultural Crop Yield Analysis"
xlabel_value = "Regions"
legend_labels = methods
annotation_texts_a = [str(y) for y in yields_region_a]
annotation_texts_b = [str(y) for y in yields_region_b]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 6))
# Colors (reflecting agriculture)
colors = ["#8FBC8F", "#DEB887", "#4682B4", "#9ACD32", "#556B2F"]

# Create bars for Region A
for i in range(len(r1)):
    plt.bar(
        xticks_values[0] + (i - 2) * bar_width,
        yields_region_a[i],
        color=colors[i],
        width=bar_width,
        edgecolor="white",
        label=labels[i] if xticks_values[0] == 6 else "",
    )

# Create bars for Region B
for i in range(len(r2)):
    plt.bar(
        xticks_values[1] + (i - 2) * bar_width,
        yields_region_b[i],
        color=colors[i],
        width=bar_width,
        edgecolor="white",
    )

# Add text on top of the bars (Region A)
for i in range(len(r1)):
    plt.text(
        xticks_values[0] + (i - 2) * bar_width,
        yields_region_a[i] + 0.05,
        str(yields_region_a[i]),
        ha="center",
    )
    
# Add text on top of the bars (Region B)
for i in range(len(r2)):
    plt.text(
        xticks_values[1] + (i - 2) * bar_width,
        yields_region_b[i] + 0.05,
        str(yields_region_b[i]),
        ha="center",
    )

# General layout
plt.xticks(xticks_values, xtickslabel_values)
plt.ylabel(ylabel_value)
plt.ylim(*ylim_values)
plt.legend(loc="upper center", ncol=5, bbox_to_anchor=(0.5, 1.15), frameon=False)
plt.title(title_text)
plt.suptitle(supertitle_text)
plt.xlabel(xlabel_value)

plt.tick_params(axis="x", which="both", length=0)
plt.gca().yaxis.grid(True)
plt.gca().set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_185.pdf", bbox_inches="tight")
