
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
clusters = [5, 10]  # Example of different regions or categories
adherents_group1 = [35.5, 40.2]  # Hypothetical percentage values
adherents_group2 = [55.3, 50.8]
random_sampling = 45.0  # Random sampling baseline

labels = ["Group 1", "Group 2"]
xlabel = "Number of Clusters"
ylabel = "Percentage of Adherents"
title = "Percentage of Religious Adherents by Number of Clusters"
axlabels = "Random Sampling Baseline"

ylim = [30, 60]  # Adjusted ylim based on the new data range

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(
    figsize=(6.61, 5.23)
)  # Adjusted to match the original image's dimensions
bar_width = 0.35
index = np.arange(len(clusters))

bar1 = ax.bar(index, adherents_group1, bar_width, label=labels[0], color="#8ca3a3")
bar2 = ax.bar(
    index + bar_width, adherents_group2, bar_width, label=labels[1], color="#f2b38d"
)

# Adding the text on the bars
for rect in bar1 + bar2:
    height = rect.get_height()
    ax.text(
        rect.get_x() + rect.get_width() / 2.0,
        height,
        "%.2f" % height,
        ha="center",
        va="bottom",
    )

# Random Sampling Line
ax.axhline(y=random_sampling, color="purple", linestyle="--", linewidth=1.5, label=axlabels)

# Labels, title and legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)  # Added title
ax.set_ylim(ylim)
ax.set_xticks(index + bar_width / 2)
ax.set_xticklabels(clusters)
ax.legend(loc="upper right")  # Changed legend position
grid_color = "#d2d2d2"
ax.yaxis.grid(True)
ax.set_axisbelow(True)
# Set border color
for spine in ax.spines.values():
    spine.set_edgecolor(grid_color)

plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout
plt.tight_layout()
plt.savefig("bar_187.pdf", bbox_inches="tight")
